/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;

public final class TechnologyDescriptor
implements ITechnologyDescriptor {
    private final ITechnologyExtensionIdentifier _techId;
    private final ITechnologyDiscoverer _discoverer;
    private volatile int hashCode = 0;

    public TechnologyDescriptor(ITechnologyExtensionIdentifier techId, ITechnologyDiscoverer discoverer) {
        this._techId = techId;
        this._discoverer = discoverer;
    }

    @Override
    public ITechnologyDiscoverer getDiscovererInstance() {
        ((AbstractTechnologyDiscoverer)this._discoverer).setTechnologyId(this._techId);
        return this._discoverer;
    }

    @Override
    public ITechnologyExtensionIdentifier getTechnologyIdentifier() {
        return this._techId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ITechnologyDescriptor)) {
            return false;
        }
        ITechnologyDescriptor other = (ITechnologyDescriptor)obj;
        return this.getTechnologyIdentifier().equals(other.getTechnologyIdentifier()) && this.getDiscovererInstance().equals(other.getDiscovererInstance());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int code = 37;
            code = 23 * code + this._techId.hashCode();
            this.hashCode = code = 23 * code + this._discoverer.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("TechnologyDescriptor: ").append(this._techId.getId());
        buf.append("[").append(this._techId.getVersion()).append("]");
        return buf.toString();
    }
}

