/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.DefaultTechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoveryEvent;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;

public class DefaultTechnologyDiscoveryProvider
extends AbstractTechnologyDiscoveryProvider {
    private static final boolean DEBUG = false;
    private boolean _stopped;
    private DefaultTechnologyDiscoverer _defaultDiscoverer;
    private final Map<String, ITechnologyExtension> _activeTechExtsMap = new HashMap<String, ITechnologyExtension>();

    public DefaultTechnologyDiscoveryProvider(Project project) {
        super(project);
        this.startDiscovery();
    }

    private void debugPrint(String output) {
    }

    private void startDiscovery() {
        if (this._techDescriptors == null) {
            this.init();
        }
        this.debugPrint("startDiscovery: " + this.getProject().getEclipseProject().getName() + ": started");
        for (ITechnologyExtensionIdentifier id : this._techDescriptors.keySet()) {
            ITechnologyDescriptor td = (ITechnologyDescriptor)this._techDescriptors.get(id);
            td.getDiscovererInstance().start();
        }
        this.debugPrint("startDiscovery: " + this.getProject().getEclipseProject().getName() + ": ended");
        this._stopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ITechnologyExtension> getActiveTechnologies() {
        if (this._stopped) {
            this.startDiscovery();
        }
        Map<String, ITechnologyExtension> techExts = this._activeTechExtsMap;
        if (this._activeTechExtsMap.isEmpty()) {
            Set<ITechnologyDescriptor> activeTechnologyDescriptors = this.getActiveTechnologyDescriptors();
            techExts = new HashMap<String, ITechnologyExtension>(activeTechnologyDescriptors.size());
            for (ITechnologyDescriptor td : activeTechnologyDescriptors) {
                ITechnologyExtension te = this.createTechExt(td);
                techExts.put(td.getTechnologyIdentifier().getId(), te);
            }
            Map<String, ITechnologyExtension> map = this._activeTechExtsMap;
            synchronized (map) {
                this._activeTechExtsMap.putAll(techExts);
            }
        }
        return DefaultTechnologyDiscoveryProvider.getTechExtensions(techExts);
    }

    private Set<ITechnologyDescriptor> getActiveTechnologyDescriptors() {
        HashSet<ITechnologyDescriptor> active = new HashSet<ITechnologyDescriptor>();
        for (ITechnologyExtensionIdentifier id : this._techDescriptors.keySet()) {
            ITechnologyDescriptor td = (ITechnologyDescriptor)this._techDescriptors.get(id);
            if (!td.getDiscovererInstance().isActive()) continue;
            this.debugPrint("getActiveTechnologyDescriptors (discovered) : " + this.getProject().getEclipseProject().getName() + ": " + td.getTechnologyIdentifier());
            active.add(td);
        }
        this.debugPrint("getActiveTechnologyDescriptors: " + this.getProject().getEclipseProject().getName() + ": ended");
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalHandleTechnologiesModified(ITechnologyDiscoveryEvent event) {
        Map<String, ITechnologyExtension> map = this._activeTechExtsMap;
        synchronized (map) {
            ITechnologyDescriptor td = (ITechnologyDescriptor)this._techDescriptors.get(event.getTechnology());
            if (td != null && event.getType().equals((Object)ITechnologyDiscoveryEvent.Type.ADDED)) {
                if (!this._activeTechExtsMap.containsKey(td.getTechnologyIdentifier().getId())) {
                    this._activeTechExtsMap.put(td.getTechnologyIdentifier().getId(), this.createTechExt(td));
                }
            } else if (td != null && event.getType().equals((Object)ITechnologyDiscoveryEvent.Type.REMOVED)) {
                ITechnologyExtension te = this._activeTechExtsMap.get(td.getTechnologyIdentifier().getId());
                if (te != null) {
                    ((AbstractTechnologyExtension)te).close();
                }
                this._activeTechExtsMap.remove(td.getTechnologyIdentifier().getId());
            } else if (td != null && event.getType().equals((Object)ITechnologyDiscoveryEvent.Type.VERSION_CHANGED)) {
                ITechnologyExtension te = this._activeTechExtsMap.get(td.getTechnologyIdentifier().getId());
                if (te != null) {
                    ((AbstractTechnologyExtension)te).close();
                }
                this._activeTechExtsMap.remove(td.getTechnologyIdentifier().getId());
                this._activeTechExtsMap.put(td.getTechnologyIdentifier().getId(), this.createTechExt(td));
            } else if (event.getType().equals((Object)ITechnologyDiscoveryEvent.Type.UNKNOWN)) {
                for (ITechnologyDescriptor techDescriptor : this.getActiveTechnologyDescriptors()) {
                    String id = techDescriptor.getTechnologyIdentifier().getId();
                    if (this._activeTechExtsMap.containsKey(id)) continue;
                    this._activeTechExtsMap.put(id, this.createTechExt(techDescriptor));
                }
            }
        }
    }

    @Override
    protected DefaultTechnologyDiscoverer getDefaultTechnologyDiscoverer(ITechnologyExtensionIdentifier techId) {
        if (this._defaultDiscoverer == null) {
            this._defaultDiscoverer = new DefaultTechnologyDiscoverer(this, techId);
            this._defaultDiscoverer.addListener(this);
        } else {
            this._defaultDiscoverer.setTechnologyId(techId);
        }
        return this._defaultDiscoverer;
    }

    private static Set<ITechnologyExtension> getTechExtensions(Map<String, ITechnologyExtension> techExts) {
        HashSet<ITechnologyExtension> ret = new HashSet<ITechnologyExtension>();
        for (ITechnologyExtension te : techExts.values()) {
            if (te == null) continue;
            ret.add(te);
        }
        return ret;
    }

    @Override
    protected void close() {
        super.close();
        if (this._activeTechExtsMap != null) {
            this._activeTechExtsMap.clear();
        }
        if (this._defaultDiscoverer != null) {
            this._defaultDiscoverer.stop();
        }
        this._stopped = true;
    }
}

