/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.eclipse.tools.common.services.project.IProjectSharedEventManager;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoveryEvent;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.services.project.technology.TechnologyToFacetMap;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class DefaultTechnologyDiscoverer
extends AbstractTechnologyDiscoverer
implements IFacetedProjectListener,
IProjectSharedEventManager.IProjectSharedEventListener {
    private final TechnologyToFacetMap _map;
    private AtomicBoolean _started = new AtomicBoolean(false);
    private AtomicInteger refCount = new AtomicInteger(0);

    public DefaultTechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
        super(technologyDiscoveryProvider, techId);
        this._map = new TechnologyToFacetMap(this.getTechnologyDiscoveryProvider().getProject().getEclipseProject(), this.getTechnologyDiscoveryProvider());
    }

    @Override
    public boolean isActive() {
        return this.checkIsActiveByFacet();
    }

    protected boolean checkIsActiveByFacet() {
        return this._map.isActiveFacet(this.getTechnologyId());
    }

    public void handleEvent(IFacetedProjectEvent event) {
        if (event.getProject().getProject().equals((Object)this.getTechnologyDiscoveryProvider().getProject().getEclipseProject()) && event instanceof IProjectFacetActionEvent && this.getType((IProjectFacetActionEvent)event) != null) {
            IProjectFacetActionEvent ev = (IProjectFacetActionEvent)event;
            for (ITechnologyExtensionIdentifier tid : this._map.getTechnologyIdentifiers(ev.getProjectFacetVersion())) {
                DefaultTechnologyDiscoveryEvent discEv = new DefaultTechnologyDiscoveryEvent(tid, this.getType(ev), ev);
                this.notifyListeners(discEv);
            }
        }
    }

    private ITechnologyDiscoveryEvent.Type getType(IProjectFacetActionEvent ev) {
        if (ev.getType().equals((Object)IFacetedProjectEvent.Type.POST_INSTALL)) {
            return ITechnologyDiscoveryEvent.Type.ADDED;
        }
        if (ev.getType().equals((Object)IFacetedProjectEvent.Type.POST_UNINSTALL)) {
            return ITechnologyDiscoveryEvent.Type.REMOVED;
        }
        if (ev.getType().equals((Object)IFacetedProjectEvent.Type.POST_VERSION_CHANGE)) {
            return ITechnologyDiscoveryEvent.Type.VERSION_CHANGED;
        }
        return null;
    }

    @Override
    public void start() {
        this.refCount.getAndIncrement();
        if (!this._started.get()) {
            FacetedProjectFramework.addListener((IFacetedProjectListener)this, (IFacetedProjectEvent.Type[])new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.POST_INSTALL, IFacetedProjectEvent.Type.POST_UNINSTALL, IFacetedProjectEvent.Type.POST_VERSION_CHANGE});
            this.getTechnologyDiscoveryProvider().getProject().addSharedEventListener(this);
        }
        this._started.set(true);
    }

    @Override
    public void stop() {
        this.refCount.getAndDecrement();
        if (this.refCount.get() <= 0 && this._started.get()) {
            FacetedProjectFramework.removeListener((IFacetedProjectListener)this);
            this.getTechnologyDiscoveryProvider().getProject().removeSharedEventListener(this);
            this._started.set(false);
        }
    }

    @Override
    public void facetedProjectStatusChanged(boolean projectIsFaceted) {
        if (projectIsFaceted) {
            this.fireDiscoveryEvent(new Object());
        }
    }

    protected void fireDiscoveryEvent(Object initiatingEvent) {
        DefaultTechnologyDiscoveryEvent discEv = new DefaultTechnologyDiscoveryEvent(new Object());
        this.notifyListeners(discEv);
    }

    protected void fireDiscoveryEvent(ITechnologyExtensionIdentifier id, ITechnologyDiscoveryEvent.Type type, Object initiatingEvent) {
        DefaultTechnologyDiscoveryEvent discEvent = new DefaultTechnologyDiscoveryEvent(id, type, initiatingEvent);
        this.notifyListeners(discEvent);
    }

    @Override
    public void resourceChanged(ISequentialResourceChangeEvent event) {
    }

    public final class DefaultTechnologyDiscoveryEvent
    implements ITechnologyDiscoveryEvent {
        private final ITechnologyExtensionIdentifier _identifier;
        private final ITechnologyDiscoveryEvent.Type _type;
        private Object _ev;

        DefaultTechnologyDiscoveryEvent(ITechnologyExtensionIdentifier id, ITechnologyDiscoveryEvent.Type type, Object initiatingEvent) {
            this._type = type;
            this._identifier = id;
            this._ev = initiatingEvent;
        }

        DefaultTechnologyDiscoveryEvent(Object initiatingEvent) {
            this._type = ITechnologyDiscoveryEvent.Type.UNKNOWN;
            this._identifier = null;
            this._ev = initiatingEvent;
        }

        @Override
        public ITechnologyExtensionIdentifier getTechnology() {
            return this._identifier;
        }

        @Override
        public ITechnologyDiscoveryEvent.Type getType() {
            return this._type;
        }

        @Override
        public ITechnologyDiscoverer getDiscoverer() {
            return DefaultTechnologyDiscoverer.this;
        }

        @Override
        public Object getInitiatingEvent() {
            return this._ev;
        }
    }
}

