/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.project.IProjectSharedEventManager;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.internal.Messages;
import oracle.eclipse.tools.common.services.resources.EventType;
import oracle.eclipse.tools.common.services.resources.ExtensibleWorkspaceChangeManager;
import oracle.eclipse.tools.common.services.resources.IResourceChange;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProjectSharedEventManager
extends ExtensibleWorkspaceChangeManager
implements IProjectSharedEventManager {
    private final Map<Project, CopyOnWriteArrayList<IProjectSharedEventManager.IProjectSharedEventListener>> listeners = new HashMap<Project, CopyOnWriteArrayList<IProjectSharedEventManager.IProjectSharedEventListener>>();
    private static final IPath FACET_MD_FILE_PATH = new Path(".settings/org.eclipse.wst.common.project.facet.core.xml");
    private volatile int numListeners;

    public ProjectSharedEventManager() {
        super("ProjectSharedEventManager");
    }

    @Override
    public void resourceChanged(final ISequentialResourceChangeEvent event) {
        if (this.numListeners == 0) {
            return;
        }
        this.handleGlobalEvents(event);
        if (event.isResourceEvent()) {
            new Job(Messages.ProjectSharedEventManager_ProjectSharedEventUpdate){

                protected IStatus run(IProgressMonitor monitor) {
                    final MultiStatus status = new MultiStatus("oracle.eclipse.tools.common.services", 0, Messages.ProjectSharedEventManager_Results, null);
                    for (IResourceChange change : event.getResourceChanges()) {
                        Project project;
                        IResource resource;
                        IProject iProject;
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (change.getFlags().size() == 1 && change.getFlags().contains((Object)IResourceChange.FLAG.MARKERS) || (iProject = (resource = change.getResource()).getProject()) == null || (project = (Project)iProject.getAdapter(Project.class)) == null) continue;
                        for (final IProjectSharedEventManager.IProjectSharedEventListener listener : ProjectSharedEventManager.this.getListenerList(project)) {
                            if (!monitor.isCanceled()) {
                                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                    public void run() throws Exception {
                                        listener.resourceChanged(event);
                                    }

                                    public void handleException(Throwable exception) {
                                        status.add((IStatus)new Status(4, "oracle.eclipse.tools.common.services", "Handling event on project " + project.getEclipseProject().toString(), exception));
                                    }
                                });
                                continue;
                            }
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return status;
                }
            }.schedule();
        }
    }

    private void handleGlobalEvents(ISequentialResourceChangeEvent event) {
        if (event.isResourceEvent() && event.getType() == EventType.RESOURCE_POST_CHANGE) {
            for (IResourceChange change : event.getResourceChanges()) {
                Project project;
                IResource changedResource = change.getResource();
                IProject iProject = changedResource.getProject();
                if (iProject == null || !iProject.isAccessible() || (project = (Project)iProject.getAdapter(Project.class)) == null) continue;
                IFile facetMdFile = iProject.getFile(FACET_MD_FILE_PATH);
                if (!project.isFacetProject() || change.getKind() != IResourceChange.KIND.ADDED || facetMdFile == null || !facetMdFile.equals((Object)changedResource)) continue;
                for (final IProjectSharedEventManager.IProjectSharedEventListener listener : this.getListenerList(project)) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            listener.facetedProjectStatusChanged(true);
                        }

                        public void handleException(Throwable exception) {
                            Activator.log("Handling event on project " + project.getEclipseProject().toString(), exception);
                        }
                    });
                }
            }
        }
    }

    @Override
    public void addListener(Project project, IProjectSharedEventManager.IProjectSharedEventListener listener) {
        this.getListenerList(project).addIfAbsent(listener);
        ++this.numListeners;
    }

    @Override
    public void removeListener(Project project, IProjectSharedEventManager.IProjectSharedEventListener listener) {
        this.getListenerList(project).remove(listener);
        --this.numListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyOnWriteArrayList<IProjectSharedEventManager.IProjectSharedEventListener> getListenerList(Project project) {
        Map<Project, CopyOnWriteArrayList<IProjectSharedEventManager.IProjectSharedEventListener>> map = this.listeners;
        synchronized (map) {
            CopyOnWriteArrayList<IProjectSharedEventManager.IProjectSharedEventListener> copyOnWriteArrayList = this.listeners.get(project);
            if (copyOnWriteArrayList == null) {
                copyOnWriteArrayList = new CopyOnWriteArrayList();
                this.listeners.put(project, copyOnWriteArrayList);
            }
            return copyOnWriteArrayList;
        }
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void discardAllListeners(Project project) {
        this.getListenerList(project).clear();
    }
}

