/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.internal;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.internal.ProjectImpl;
import org.eclipse.core.resources.IProject;

public class ProjectManager {
    private static final ProjectManager sINSTANCE = new ProjectManager();
    private final Map<IProject, Project> projectCacheMap = new HashMap<IProject, Project>();

    public static final ProjectManager getInstance() {
        return sINSTANCE;
    }

    private ProjectManager() {
    }

    synchronized Project get(IProject eclipseProject) {
        Project project = this.projectCacheMap.get(eclipseProject);
        if (project != null) {
            return project;
        }
        project = new ProjectImpl(eclipseProject);
        if (eclipseProject.isAccessible()) {
            this.projectCacheMap.put(eclipseProject, project);
        }
        return project;
    }

    public synchronized void projectClosed(IProject eclipseProject) {
        ProjectImpl p = (ProjectImpl)this.get(eclipseProject);
        if (p != null) {
            p.close();
        }
        this.projectCacheMap.remove(eclipseProject);
    }
}

