/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.internal;

import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.document.internal.DocumentManager;
import oracle.eclipse.tools.common.services.project.EnvFileListener;
import oracle.eclipse.tools.common.services.project.IProjectSharedEventManager;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.ProjectProperties;
import oracle.eclipse.tools.common.services.project.app.services.IAppService;
import oracle.eclipse.tools.common.services.project.internal.DefaultFileChangeReporter;
import oracle.eclipse.tools.common.services.project.internal.ProjectPropertiesImpl;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.DefaultTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.IProjectTechnologyChangeListener;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.Version;

public class ProjectImpl
implements Project {
    private final IProject _proj;
    private final DocumentManager _documentManager;
    private final DefaultFileChangeReporter _fileChangeReporter;
    private AbstractTechnologyDiscoveryProvider _techDP;
    private ProjectProperties _projProps;

    ProjectImpl(IProject proj) {
        this._proj = proj;
        this._documentManager = new DocumentManager();
        this._fileChangeReporter = new DefaultFileChangeReporter();
    }

    @Override
    public <T extends IAppService> T getAppService(Class<T> adapter) {
        if (this._proj == null || !this._proj.isAccessible()) {
            return null;
        }
        this.getTechDiscProvider();
        assert (adapter != null);
        return (T)((IAppService)Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName()));
    }

    @Override
    public IProject getEclipseProject() {
        return this._proj;
    }

    @Override
    public Set<ITechnologyExtension> getTechnologyExtensions() {
        return this.getTechDiscProvider().getActiveTechnologies();
    }

    private synchronized AbstractTechnologyDiscoveryProvider getTechDiscProvider() {
        if (this._techDP == null) {
            this._techDP = new DefaultTechnologyDiscoveryProvider(this);
        }
        return this._techDP;
    }

    @Override
    public ITechnologyExtension getTechnologyExtensionById(String id) {
        for (ITechnologyExtension ext : this.getTechnologyExtensions()) {
            if (!ext.getId().equals(id)) continue;
            return ext;
        }
        return null;
    }

    @Override
    public synchronized ProjectProperties getProjectProperties() {
        if (this._projProps == null) {
            this._projProps = new ProjectPropertiesImpl(this);
        }
        return this._projProps;
    }

    @Override
    public void addTechnologiesChangedListener(IProjectTechnologyChangeListener listener) {
        this.getTechDiscProvider().addListener(listener);
    }

    @Override
    public void removeTechnologiesChangeListener(IProjectTechnologyChangeListener listener) {
        this.getTechDiscProvider().removeListener(listener);
    }

    @Override
    public void addResourceChangeListener(EnvFileListener listener) {
        this._fileChangeReporter.addListener(listener);
    }

    @Override
    public void removeResourceChangeListener(EnvFileListener listener) {
        this._fileChangeReporter.removeListener(listener);
    }

    public void close() {
        if (this._techDP != null) {
            this._techDP.projectClosing();
        }
        Activator.getDefault().getProjectSharedEventManager().discardAllListeners(this);
    }

    @Override
    public DocumentManager getDocumentManager() {
        return this._documentManager;
    }

    public int hashCode() {
        return this._proj == null ? 0 : this._proj.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectImpl other = (ProjectImpl)obj;
        return !(this._proj == null ? other._proj != null : !this._proj.equals((Object)other._proj));
    }

    @Override
    public void addSharedEventListener(IProjectSharedEventManager.IProjectSharedEventListener listener) {
        Activator.getDefault().getProjectSharedEventManager().addListener(this, listener);
    }

    @Override
    public void removeSharedEventListener(IProjectSharedEventManager.IProjectSharedEventListener listener) {
        Activator.getDefault().getProjectSharedEventManager().removeListener(this, listener);
    }

    @Override
    public boolean isFacetProject() {
        try {
            return FacetedProjectFramework.isFacetedProject((IProject)this.getEclipseProject());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public boolean hasTechnology(String id, String minVersionStr) {
        ITechnologyExtension myTechExt = this.getTechnologyExtensionById(id);
        if (myTechExt != null) {
            String version = myTechExt.getVersion();
            Version myVersion = ProjectImpl.createVersion(version);
            Version minVersion = ProjectImpl.createVersion(minVersionStr);
            if (minVersion.compareTo(myVersion) <= 0) {
                return true;
            }
        }
        return false;
    }

    private static Version createVersion(String version) {
        if (version == null || version.isEmpty()) {
            return new Version(0, 0, 0);
        }
        String[] segments = version.split("\\.");
        int[] versionVals = new int[3];
        int i = 0;
        while (i < segments.length && i < versionVals.length) {
            try {
                versionVals[i] = Integer.parseInt(segments[i]);
            }
            catch (NumberFormatException nfe) {
                Activator.log(String.format("Unsupported version string %s", version), nfe);
                return new Version(0, 0, 0);
            }
            ++i;
        }
        return new Version(versionVals[0], versionVals[1], versionVals[2]);
    }
}

