/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.internal;

import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.project.AbstractFileEventSource;
import oracle.eclipse.tools.common.services.project.ExceptionHandler;
import oracle.eclipse.tools.common.services.project.FileEvent;
import oracle.eclipse.tools.common.services.project.internal.EclipseDeltaVisitor;
import oracle.eclipse.tools.common.services.project.internal.IFileChangeReporter;
import oracle.eclipse.tools.common.services.project.internal.Messages;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class DefaultFileChangeReporter
extends AbstractFileEventSource
implements IFileChangeReporter {
    private final MyResourceListener _resourceChangedListener = new MyResourceListener(this);
    private final ExceptionHandler _exceptionHandler;

    public DefaultFileChangeReporter() {
        this(new ExceptionHandler(){

            @Override
            public void handleException(Throwable exception) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)exception);
            }
        });
    }

    public DefaultFileChangeReporter(ExceptionHandler exceptionHandler) {
        this._exceptionHandler = exceptionHandler;
    }

    @Override
    protected void doListenerListIsEmpty() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this._resourceChangedListener);
    }

    @Override
    protected void doListenerListNoLongerEmpty() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this._resourceChangedListener);
    }

    @Override
    public void fireResourceAdded(final IResource resourceAdded, final IProgressMonitor progress) {
        if (this.isFileFilteredForEvents(resourceAdded)) {
            return;
        }
        this.fireEvent(new MySafeRunnable(this._exceptionHandler){

            public void run() throws Exception {
                this.getListener().fileAdded(new FileEvent(resourceAdded, FileEvent.Type.ADDED, progress));
            }
        });
    }

    @Override
    public void fireResourceModified(final IResource fileModified, final IProgressMonitor progress) {
        if (this.isFileFilteredForEvents(fileModified)) {
            return;
        }
        this.fireEvent(new MySafeRunnable(this._exceptionHandler){

            public void run() throws Exception {
                this.getListener().fileChanged(new FileEvent(fileModified, FileEvent.Type.MODIFIED, progress));
            }
        });
    }

    @Override
    public void fireResourceMoved(final IResource oldLocation, final IResource newLocation, final IProgressMonitor progress) {
        if (this.isFileFilteredForEvents(newLocation)) {
            return;
        }
        this.fireEvent(new MySafeRunnable(this._exceptionHandler){

            public void run() throws Exception {
                this.getListener().fileMoved(new FileEvent(oldLocation, newLocation, progress));
            }
        });
    }

    @Override
    public void fireResourceRemoved(final IResource resourceRemoved, final IProgressMonitor progress) {
        if (this.isFileFilteredForEvents(resourceRemoved)) {
            return;
        }
        this.fireEvent(new MySafeRunnable(this._exceptionHandler){

            public void run() throws Exception {
                this.getListener().fileRemoved(new FileEvent(resourceRemoved, FileEvent.Type.REMOVED, progress));
            }
        });
    }

    private boolean isFileFilteredForEvents(IResource resourceAdded) {
        return false;
    }

    private static class MyResourceListener
    implements IResourceChangeListener {
        private final IFileChangeReporter _reporter;

        public MyResourceListener(IFileChangeReporter reporter) {
            this._reporter = reporter;
        }

        public void resourceChanged(final IResourceChangeEvent event) {
            new WorkspaceJob(Messages.DefaultFileChangeReporter_0){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    IResourceDelta delta = event.getDelta();
                    if (delta != null) {
                        new EclipseDeltaVisitor(MyResourceListener.this._reporter, monitor, 0).visit(delta);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private static abstract class MySafeRunnable
    extends AbstractFileEventSource.FileListenerRunnable {
        private final ExceptionHandler _exceptionHandler;

        public MySafeRunnable(ExceptionHandler exceptionHandler) {
            this._exceptionHandler = exceptionHandler;
        }

        public void handleException(Throwable exception) {
            this._exceptionHandler.handleException(exception);
        }
    }
}

