/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project;

import java.util.EventObject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileEvent
extends EventObject {
    private static final long serialVersionUID = -5280586027401379212L;
    private final IProgressMonitor mMonitor;
    private final Type mEventType;
    private final IResource newResource;
    private final IResource oldResource;

    public FileEvent(IResource changedResource, Type eventType, IProgressMonitor monitor) {
        super(changedResource);
        this.newResource = changedResource;
        this.oldResource = null;
        this.mEventType = eventType;
        this.mMonitor = monitor;
    }

    public FileEvent(IResource movedFromLocation, IResource movedToLocation, IProgressMonitor monitor) {
        super(movedFromLocation);
        this.newResource = movedToLocation;
        this.oldResource = movedFromLocation;
        this.mEventType = Type.MOVED;
        this.mMonitor = monitor;
    }

    public FileEvent(FileEvent fileEvent) {
        super(fileEvent.source);
        this.newResource = fileEvent.newResource;
        this.oldResource = fileEvent.oldResource;
        this.mEventType = fileEvent.mEventType;
        this.mMonitor = fileEvent.mMonitor;
    }

    public Type getEventType() {
        return this.mEventType;
    }

    public IResource getSource() {
        return (IResource)this.source;
    }

    public IResource getChangedResource() {
        return this.getSource();
    }

    public IResource getMovedToLocation() {
        return this.newResource;
    }

    public IResource getMovedFromLocation() {
        return this.oldResource;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.mMonitor;
    }

    public static enum Type {
        ADDED,
        REMOVED,
        MODIFIED,
        MOVED;

    }
}

