/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project;

import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.common.services.project.EnvFileListener;
import oracle.eclipse.tools.common.services.project.internal.IFileEventSource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public abstract class AbstractFileEventSource
implements IFileEventSource {
    protected final CopyOnWriteArrayList<EnvFileListener> _listeners = new CopyOnWriteArrayList();

    protected AbstractFileEventSource() {
    }

    @Override
    public synchronized void addListener(EnvFileListener fileListener) {
        boolean wasEmpty = this._listeners.isEmpty();
        this._listeners.addIfAbsent(fileListener);
        if (wasEmpty) {
            this.doListenerListNoLongerEmpty();
        }
    }

    @Override
    public synchronized boolean hasListeners() {
        return !this._listeners.isEmpty();
    }

    @Override
    public synchronized void removeListener(EnvFileListener fileListener) {
        boolean isEmpty;
        boolean bl = isEmpty = this._listeners.size() == 1;
        if (isEmpty &= this._listeners.remove(fileListener)) {
            this.doListenerListIsEmpty();
        }
    }

    protected void fireEvent(FileListenerRunnable runnable) {
        for (EnvFileListener l : this._listeners) {
            runnable.setListener(l);
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    protected abstract void doListenerListIsEmpty();

    protected abstract void doListenerListNoLongerEmpty();

    protected static abstract class FileListenerRunnable
    implements ISafeRunnable {
        private EnvFileListener _listener;

        protected FileListenerRunnable() {
        }

        public void setListener(EnvFileListener listener) {
            this._listener = listener;
        }

        public final EnvFileListener getListener() {
            return this._listener;
        }
    }
}

