/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.internal;

import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.resources.internal.SequentialEventManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class SaveParticipant
implements ISaveParticipant {
    public void doneSaving(ISaveContext context) {
        switch (context.getKind()) {
            case 1: 
            case 3: {
                SequentialEventManager mgr = Activator.getDefault().getSequentialEventManager();
                mgr.restartIfPaused();
            }
        }
    }

    public void rollback(ISaveContext context) {
        switch (context.getKind()) {
            case 1: 
            case 3: {
                SequentialEventManager mgr = Activator.getDefault().getSequentialEventManager();
                mgr.restartIfPaused();
            }
        }
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        switch (context.getKind()) {
            case 1: 
            case 3: {
                SequentialEventManager mgr = Activator.getDefault().getSequentialEventManager();
                mgr.pauseCommandExecutionNoWait();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saving(ISaveContext context) throws CoreException {
        SequentialEventManager mgr = Activator.getDefault().getSequentialEventManager();
        switch (context.getKind()) {
            case 1: {
                mgr.safeControlledPause();
                try {
                    context.needDelta();
                    context.needSaveNumber();
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    MultiStatus ms = new MultiStatus("oracle.eclipse.tools.common.services", 0, "", null);
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            if (ms.isOK()) return;
                            throw new CoreException((IStatus)ms);
                        }
                        IProject project = iProjectArray[n2];
                        if (project.isOpen()) {
                            IStatus status = DependencyModelManager.getInstance().storeProject(project, context);
                            if (!status.isOK()) {
                                ms.add(status);
                            }
                            if (!(status = mgr.storeCommands(context, project)).isOK()) {
                                ms.add(status);
                            }
                        }
                        ++n2;
                    }
                }
                finally {
                    mgr.restartIfPaused();
                }
            }
            case 3: {
                mgr.safeControlledPause();
                try {
                    context.needDelta();
                    context.needSaveNumber();
                    IProject project = context.getProject();
                    if (!project.isOpen()) {
                    }
                    IStatus status = DependencyModelManager.getInstance().storeProject(project, context);
                    if (!status.isOK()) {
                        throw new CoreException(status);
                    }
                    status = mgr.storeCommands(context, project);
                    if (!status.isOK()) {
                        throw new CoreException(status);
                    }
                }
                finally {
                    mgr.restartIfPaused();
                }
            }
        }
    }
}

