/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.document.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.document.Document;
import oracle.eclipse.tools.common.services.document.DocumentServiceAdapterFactory;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.internal.DocumentDescriptor;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.ResourceSingletonObjectManager;

public class DocumentManager
extends ResourceSingletonObjectManager<IDocument, IFile> {
    private static final String DOC_EXT_ADAPTER_FACTORY = "adapterFactory";
    private static final String DOC_EXT_ID = "id";
    private static final String EXT_PT = "oracle.eclipse.tools.common.services.document";
    private static final String DOC_EXT_CONTENT_TYPE_ID = "id";
    private static final Map<String, DocumentDescriptor> GLOBAL_DESCRIPTOR_MAP;
    private final Map<String, DocumentDescriptor> _myDescriptorMap;

    static {
        Map<String, DocumentDescriptor> descriptorMap = null;
        try {
            descriptorMap = DocumentManager.loadDocumentDescriptors();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GLOBAL_DESCRIPTOR_MAP = descriptorMap != null ? Collections.unmodifiableMap(descriptorMap) : Collections.emptyMap();
    }

    public DocumentManager() {
        this(ResourcesPlugin.getWorkspace(), GLOBAL_DESCRIPTOR_MAP);
    }

    protected DocumentManager(IWorkspace wkspace, Map<String, DocumentDescriptor> descriptors) {
        super(wkspace);
        this._myDescriptorMap = descriptors;
    }

    private static Map<String, DocumentDescriptor> loadDocumentDescriptors() {
        IConfigurationElement[] extpts;
        HashMap<String, DocumentDescriptor> descriptors = new HashMap<String, DocumentDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = extpts = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_PT);
        int n = extpts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extpt = iConfigurationElementArray[n2];
            try {
                String id = extpt.getAttribute("id");
                List<String> contentTypes = DocumentManager.getContentTypes(extpt);
                DocumentServiceAdapterFactory factory = (DocumentServiceAdapterFactory)extpt.createExecutableExtension(DOC_EXT_ADAPTER_FACTORY);
                descriptors.put(id, new DocumentDescriptor(id, contentTypes, factory));
            }
            catch (CoreException ce) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)ce);
            }
            ++n2;
        }
        return Collections.unmodifiableMap(descriptors);
    }

    public IDocument getDocument(IFile file) {
        try {
            return (IDocument)this.getInstance((IResource)file);
        }
        catch (ObjectManager.ManagedObjectException e) {
            if (TraceOptions.DOCUMENT_MANAGER) {
                Activator.log("Could not create document for file: " + file.toString(), e);
            }
            return null;
        }
    }

    protected final IDocument createNewInstance(IFile file) {
        assert (file != null);
        this.ensureSyncedWithFileSystem(file);
        DocumentDescriptor descriptor = this.getDocumentDescriptor(file);
        if (descriptor != null) {
            return this.createDocumentInstance(file, descriptor);
        }
        return null;
    }

    private void ensureSyncedWithFileSystem(IFile file) {
        if (!file.isSynchronized(0)) {
            try {
                file.refreshLocal(0, null);
            }
            catch (CoreException e) {
                Activator.log("Unable to refresh file: " + file.getName(), e);
            }
        }
    }

    private DocumentDescriptor getDocumentDescriptor(IFile file) {
        IContentDescription contentDesc = this.getContentDescription(file);
        DocumentDescriptor descriptor = null;
        if (contentDesc != null) {
            for (DocumentDescriptor desc : this._myDescriptorMap.values()) {
                if (!desc.matches(contentDesc)) continue;
                descriptor = desc;
                break;
            }
        }
        return descriptor;
    }

    private IContentDescription getContentDescription(IFile file) {
        IContentDescription contentDesc;
        block3: {
            if (!file.exists()) {
                return null;
            }
            contentDesc = null;
            try {
                contentDesc = file.getContentDescription();
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (e instanceof ResourceException && status != null && status.getCode() == 274) break block3;
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
            }
        }
        return contentDesc;
    }

    private IDocument createDocumentInstance(IFile file, DocumentDescriptor descriptor) {
        return new Document(file, descriptor);
    }

    private static List<String> getContentTypes(IConfigurationElement extpt) {
        IConfigurationElement[] extChildren;
        ArrayList<String> contentTypes = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = extChildren = extpt.getChildren();
        int n = extChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String type = element.getAttribute("id");
            contentTypes.add(type);
            ++n2;
        }
        return contentTypes;
    }
}

