/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.validation;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.TypeReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.dependency.validation.Messages;
import oracle.eclipse.tools.common.services.resources.internal.SequentialEventManager;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.util.internal.ProgressMonitorUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ArtifactValidator
extends AbstractValidator
implements IValidator {
    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        if (resource == null || resource.getType() != 1) {
            return null;
        }
        if (activator.getPreferences().getProjectPreferences(resource.getProject()).isDisabled()) {
            return null;
        }
        ArtifactController controller = ArtifactControllerFactory.getController();
        SequentialEventManager eventManager = activator.getSequentialEventManager();
        if (eventManager == null) {
            return null;
        }
        int currentEvent = eventManager.getCurrentEvent();
        eventManager.executeCommands(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1), currentEvent);
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        ResourceArtifact resourceArtifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact(resource);
        this.validateReferences(resourceArtifact, resource, controller, reporter);
        return result;
    }

    private void validateReferences(IArtifact artifact, IResource resource, ArtifactController controller, IReporter reporter) {
        Set<IArtifactReference> references = artifact.getReferences();
        for (IArtifactReference reference : references) {
            IArtifact target;
            if (reference.isMissing()) {
                this.reportMissingReference(reference, (IFile)resource, reporter);
                continue;
            }
            if (!reference.isTargetDefinedByReferringSource() || (target = reference.getTargetArtifact()) == null || target.isMissing()) continue;
            this.validateReferences(target, resource, controller, reporter);
        }
        Set<IArtifact> children = controller.getArtifactChildren(artifact);
        for (IArtifact child : children) {
            if (!(child instanceof IVirtualArtifact)) continue;
            this.validateReferences(child, resource, controller, reporter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reportMissingReference(IArtifactReference reference, IFile file, IReporter reporter) {
        HashSet<IArtifactReferenceLocation> localLocations = new HashSet<IArtifactReferenceLocation>();
        for (IArtifactReferenceLocation location : reference.getLocations()) {
            ResourceLocation resourceLocation = location.getResourceLocation();
            if (resourceLocation == null || !file.equals((Object)resourceLocation.getResource())) continue;
            localLocations.add(location);
        }
        if (localLocations.isEmpty()) {
            return;
        }
        String message = null;
        message = reference instanceof TypeReference ? NLS.bind((String)Messages.ArtifactValidator_missingType, (Object)reference.getName()) : NLS.bind((String)Messages.ArtifactValidator_missingResource, (Object)reference.getName());
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) return;
        IStructuredModel structuredModel = null;
        try {
            try {
                structuredModel = manager.getModelForRead(file);
                IStructuredDocument document = structuredModel.getStructuredDocument();
                for (IArtifactReferenceLocation location : localLocations) {
                    LocalizedMessage missingReferenceMessage = new LocalizedMessage(2, message, (IResource)file);
                    if (location.getResourceLocation().getRange().getOffset() < Integer.MAX_VALUE) {
                        missingReferenceMessage.setOffset((int)location.getResourceLocation().getRange().getOffset());
                    }
                    if (location.getResourceLocation().getRange().getLength() < Integer.MAX_VALUE) {
                        missingReferenceMessage.setLength((int)location.getResourceLocation().getRange().getLength());
                    }
                    if (document != null) {
                        int lineNumber = document.getLineOfOffset(missingReferenceMessage.getOffset());
                        missingReferenceMessage.setLineNo(lineNumber + 1);
                    }
                    reporter.addMessage((IValidator)this, (IMessage)missingReferenceMessage);
                }
                return;
            }
            catch (CoreException ce) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)ce);
                if (structuredModel == null) return;
                structuredModel.releaseFromRead();
                return;
            }
            catch (IOException ioe) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)ioe);
                if (structuredModel == null) return;
                structuredModel.releaseFromRead();
                return;
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
    }
}

