/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.structuredmodel.internal;

import oracle.eclipse.tools.common.services.dependency.ErrorMessages;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IModelProvider;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.internal.VisitableDOMDocument;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.traversal.NodeFilter;

public class VisitableDOMModel
implements IVisitableDOMModel {
    private final IDOMModel model;
    private final VisitableDOMDocument document;
    private final IModelProvider modelProvider;

    public VisitableDOMModel(IModelProvider provider, IDOMModel model) {
        if (model == null) {
            throw new IllegalArgumentException(ErrorMessages.nullModel);
        }
        this.model = model;
        IDOMDocument domDocument = model.getDocument();
        this.document = domDocument == null ? null : new VisitableDOMDocument(domDocument);
        this.modelProvider = provider;
    }

    @Override
    public void dispose() {
        try {
            this.model.releaseFromRead();
        }
        catch (IllegalStateException illegalStateException) {}
        if (this.modelProvider != null) {
            this.modelProvider.dispose();
        }
    }

    @Override
    public void accept(IStructuredXMLModelVisitor visitor) {
        this.accept(visitor, null, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void accept(IStructuredXMLModelVisitor visitor, NodeFilter filter, IProgressMonitor monitor) {
        this.document.accept(visitor, filter, monitor);
    }

    @Override
    public IDOMModel getModel() {
        return this.model;
    }
}

