/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.structuredmodel.internal;

import oracle.eclipse.tools.common.services.dependency.ErrorMessages;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMDocument;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.internal.VisitableDOMElement;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.internal.VisitableDOMNode;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

class VisitableDOMDocument
implements IVisitableDOMDocument {
    private final IDOMDocument document;

    VisitableDOMDocument(IDOMDocument document) {
        if (document == null) {
            throw new IllegalArgumentException(ErrorMessages.nullDocument);
        }
        this.document = document;
    }

    @Override
    public void accept(IStructuredXMLModelVisitor visitor, NodeFilter filter, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (visitor.visit(this.document)) {
            if (this.document instanceof DocumentImpl) {
                DocumentTraversal documentTraversal = (DocumentTraversal)this.document;
                TreeWalker walker = documentTraversal.createTreeWalker((Node)this.document, 129, filter, false);
                Node node = walker.firstChild();
                while (!(node == null || monitor != null && monitor.isCanceled())) {
                    if (node instanceof IDOMElement) {
                        new VisitableDOMElement((IDOMElement)node).accept(visitor, walker);
                    } else if (node instanceof IDOMNode) {
                        new VisitableDOMNode((IDOMNode)node).accept(visitor);
                    }
                    walker.setCurrentNode(node);
                    node = walker.nextSibling();
                }
            } else {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Error document was not a DocumentImpl it was [" + (this.document == null ? "null" : this.document.getClass()) + "]"));
            }
        }
    }
}

