/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.structuredmodel;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IModelProvider;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.ModelProviderBuilder;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelManagerModelProvider;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.internal.VisitableDOMModel;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class StructuredModelFactory {
    private static final String EXT_PT = "modelProvider";
    private static final Set<ModelProviderBuilder> sMODEL_PROVIDER_BUILDERS = Collections.unmodifiableSet(StructuredModelFactory.readExtensionPoints());

    public static IVisitableDOMModel getVisitableModelForRead(IFile file) throws CoreException, IOException {
        IModelProvider provider = null;
        IContentType cType = StructuredModelFactory.getContentType((IResource)file);
        for (ModelProviderBuilder builder : sMODEL_PROVIDER_BUILDERS) {
            if (builder.getSupportedContentType() == null || !builder.getSupportedContentType().equals(cType)) continue;
            provider = builder.build();
        }
        if (provider == null) {
            provider = StructuredModelFactory.getDefaultProvider();
        }
        return StructuredModelFactory.getModelFromProvider(provider, file);
    }

    public static IVisitableDOMModel getVisitableModelForRead(IFile file, String modelProvider) throws CoreException, IOException {
        IModelProvider provider = StructuredModelFactory.getProvider(modelProvider);
        return StructuredModelFactory.getModelFromProvider(provider, file);
    }

    private static IVisitableDOMModel getModelFromProvider(IModelProvider provider, IFile file) throws CoreException, IOException {
        if (provider != null) {
            long timestamp = 0L;
            if (TraceOptions.APPXRAY_PERF) {
                timestamp = System.nanoTime();
            }
            IStructuredModel structuredModel = provider.getModelForRead(file);
            if (TraceOptions.APPXRAY_PERF) {
                StringBuffer sb = new StringBuffer(256);
                sb.append("StructuredModelFactory get model from ");
                sb.append(provider.getClass().getSimpleName());
                sb.append(" for ");
                sb.append(file.getName());
                sb.append(" in project ");
                sb.append(file.getProject().getName());
                sb.append(" with time ns, ");
                sb.append(System.nanoTime() - timestamp);
                TraceOptions.log(sb.toString());
            }
            if (structuredModel instanceof IDOMModel) {
                return new VisitableDOMModel(provider, (IDOMModel)structuredModel);
            }
        }
        return null;
    }

    private static IContentType getContentType(IResource resource) throws CoreException {
        if (resource != null && resource.isAccessible() && 1 == resource.getType()) {
            IContentDescription contentDesc = null;
            try {
                contentDesc = ((IFile)resource).getContentDescription();
            }
            catch (ResourceException re) {
                IStatus status = re.getStatus();
                if (status == null || status.getCode() != 274) {
                    throw re;
                }
                ((IFile)resource).refreshLocal(0, null);
                contentDesc = ((IFile)resource).getContentDescription();
            }
            if (contentDesc != null) {
                return contentDesc.getContentType();
            }
        }
        return null;
    }

    private static IModelProvider getProvider(String modelProviderID) {
        if (modelProviderID != null) {
            for (ModelProviderBuilder builder : sMODEL_PROVIDER_BUILDERS) {
                if (!modelProviderID.equals(builder.getProviderID())) continue;
                return builder.build();
            }
        }
        return null;
    }

    private static Set<ModelProviderBuilder> readExtensionPoints() {
        LinkedHashSet<ModelProviderBuilder> builders = new LinkedHashSet<ModelProviderBuilder>();
        try {
            Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.common.services", (String)EXT_PT);
            block3: for (IExtension extension : extensions) {
                IConfigurationElement[] elems;
                IConfigurationElement[] iConfigurationElementArray = elems = extension.getConfigurationElements();
                int n = elems.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement modelProviderElement = iConfigurationElementArray[n2];
                    ModelProviderBuilder builder = new ModelProviderBuilder(modelProviderElement.getContributor().getName());
                    builder.setProviderID(PluginUtil.findRequiredAttribute((IConfigurationElement)modelProviderElement, (String)"model-provider-id"));
                    builder.setContentType(PluginUtil.findRequiredAttribute((IConfigurationElement)modelProviderElement, (String)"content-type-id"));
                    IConfigurationElement modelProviderClassElement = PluginUtil.findOptionalElement((IConfigurationElement)modelProviderElement, (String)"model-provider-class");
                    IConfigurationElement modelProviderFactoryElement = null;
                    if (modelProviderClassElement == null) {
                        modelProviderFactoryElement = PluginUtil.findOptionalElement((IConfigurationElement)modelProviderElement, (String)"model-provider-factory");
                        if (modelProviderFactoryElement == null) {
                            PluginUtil.reportInvalildElement((IExtension)extension, (IConfigurationElement)modelProviderElement);
                            continue block3;
                        }
                        builder.setProviderFactoryClass(PluginUtil.findRequiredAttribute((IConfigurationElement)modelProviderFactoryElement, (String)"factory-class"));
                    } else {
                        builder.setProviderClass(PluginUtil.findRequiredAttribute((IConfigurationElement)modelProviderClassElement, (String)"class-name"));
                    }
                    IConfigurationElement enablementElement = PluginUtil.findOptionalElement((IConfigurationElement)modelProviderElement, (String)"enablement");
                    Expression expression = null;
                    if (enablementElement != null) {
                        expression = ExpressionConverter.getDefault().perform(enablementElement);
                        builder.setEnablementExpression(expression);
                    }
                    builders.add(builder);
                    ++n2;
                }
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)ce);
        }
        catch (PluginUtil.InvalidExtensionException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        return builders;
    }

    private static IModelProvider getDefaultProvider() {
        return new StructuredModelManagerModelProvider();
    }
}

