/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.structuredmodel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IModelProvider;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class ModelProviderBuilder {
    private String providerClassName = null;
    private String providerFactoryClassName = null;
    private Expression expression = null;
    private String providerID = null;
    private IContentType contentType = null;
    private final String pluginID;

    public ModelProviderBuilder(String pluginID) {
        this.pluginID = pluginID;
    }

    public IModelProvider build() {
        if (this.providerClassName == null && this.providerFactoryClassName == null) {
            throw new IllegalStateException("Exactly one of provider-class or provider-factory is allowed");
        }
        IModelProvider mp = null;
        if (this.providerClassName != null) {
            mp = (IModelProvider)PluginUtil.instantiate((String)this.pluginID, (String)this.providerClassName, IModelProvider.class);
            if (mp == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Unable to instantiate " + this.providerClassName + " for plugin " + this.pluginID));
            }
        } else {
            Class providerFactoryClass = PluginUtil.loadClass((String)this.pluginID, (String)this.providerFactoryClassName);
            if (providerFactoryClass != null) {
                try {
                    Method getModelProviderMethod = providerFactoryClass.getMethod("getModelProvider", null);
                    Object provider = getModelProviderMethod.invoke(null, null);
                    if (provider instanceof IModelProvider) {
                        mp = (IModelProvider)provider;
                    } else {
                        LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)(String.valueOf(this.providerFactoryClassName) + "#getModelProvider() did not return an instance of ModelProvider"));
                    }
                }
                catch (NoSuchMethodException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
            }
        }
        return mp;
    }

    public ModelProviderBuilder setProviderID(String providerID) {
        this.providerID = providerID;
        return this;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public ModelProviderBuilder setProviderClass(String providerClassName) {
        if (this.providerFactoryClassName != null) {
            throw new IllegalStateException("Exactly one of provider-class or provider-factory is allowed");
        }
        this.providerClassName = providerClassName;
        return this;
    }

    public ModelProviderBuilder setProviderFactoryClass(String providerFactoryClassName) {
        if (this.providerClassName != null) {
            throw new IllegalStateException("Exactly one of provider-class or provider-factory is allowed");
        }
        this.providerFactoryClassName = providerFactoryClassName;
        return this;
    }

    public ModelProviderBuilder setEnablementExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public boolean isEnabledFor(IResource resource) throws CoreException {
        if (this.expression == null) {
            return true;
        }
        EvaluationContext evalContext = new EvaluationContext(null, (Object)resource);
        evalContext.setAllowPluginActivation(true);
        return EvaluationResult.TRUE == this.expression.evaluate((IEvaluationContext)evalContext);
    }

    public ModelProviderBuilder setContentType(String id) {
        if ("DEFAULT".equals(id)) {
            this.contentType = null;
        } else {
            IContentTypeManager mgr = Platform.getContentTypeManager();
            this.contentType = mgr.getContentType(id);
        }
        return this;
    }

    public IContentType getSupportedContentType() {
        return this.contentType;
    }
}

