/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.service;

import java.io.IOException;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.dependency.service.CollectableNodeAdapterFactory;
import oracle.eclipse.tools.common.services.dependency.service.ICollectableNode;
import oracle.eclipse.tools.common.services.dom.util.AbstractDOMNodeVisitor;
import oracle.eclipse.tools.common.services.dom.util.DOMVisitorAdapter;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class NodeCollectionService {
    private IFile _adaptableObject;

    public NodeCollectionService(IFile adaptableObject) {
        this._adaptableObject = adaptableObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void collectArtifacts() {
        IModelManager manager = StructuredModelManager.getModelManager();
        IDOMModel model = null;
        try {
            try {
                model = (IDOMModel)manager.getModelForRead(this._adaptableObject);
                CollectableNodeAdapterFactory factory = new CollectableNodeAdapterFactory();
                factory.ensureFactoryIsInstalled((IStructuredModel)model);
                IDOMDocument document = model.getDocument();
                DOMVisitorAdapter visitorAdapter = new DOMVisitorAdapter((Node)document);
                AbstractDOMNodeVisitor testVisitor = new AbstractDOMNodeVisitor(){

                    @Override
                    public void visit(Node curNode) {
                        INodeNotifier node;
                        ICollectableNode adapterFor;
                        if (curNode instanceof INodeNotifier && (adapterFor = (ICollectableNode)(node = (INodeNotifier)curNode).getAdapterFor(ICollectableNode.class)) != null) {
                            adapterFor.collectArtifacts();
                        }
                    }
                };
                visitorAdapter.accept(testVisitor);
                return;
            }
            catch (IOException ioe) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)ioe, (String)"Problem during node collection");
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Problem during node collection");
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }
}

