/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.resources.ICommand;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

final class ProjectRefreshCommand
implements ICommand {
    private static final long serialVersionUID = 1L;
    private final IProject project;

    ProjectRefreshCommand(IProject project) {
        this.project = project;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor, ITransactionContext context, boolean avoidUpdate) {
        DependencyModelManager.getInstance().refresh(this.project, monitor, context);
        return Status.OK_STATUS;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ProjectRefreshCommand && this.project.equals((Object)((ProjectRefreshCommand)obj).getProject());
    }

    public String toString() {
        return "ProjectRefreshCommand [" + this.project + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput(out);
        su.writeResource((IResource)this.project);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalProjectFromStream(this, "project");
    }
}

