/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.dependency.DependencyMessages;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.dependency.model.internal.IDiscoveryStore;
import oracle.eclipse.tools.common.services.dependency.model.internal.ResourceSetCommand;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.resources.ICommand;
import oracle.eclipse.tools.common.services.resources.internal.SequentialEventManager;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

public class ProjectLoadCommand
implements ICommand,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IProject project;
    private final int saveNumber;

    public ProjectLoadCommand(IProject project, int saveNumber) {
        this.project = project;
        this.saveNumber = saveNumber;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor, ITransactionContext context, boolean avoidUpdate) {
        if (this.project == null || !this.project.isAccessible()) {
            return Status.OK_STATUS;
        }
        if (this.saveNumber > 0) {
            SafeRunnable runnable = new SafeRunnable();
            SafeRunner.run((ISafeRunnable)runnable);
            IStatus status = runnable.getStatus();
            if (status.isOK()) {
                return new Status(0, "oracle.eclipse.tools.common.services", 0, DependencyMessages.bind((String)DependencyMessages.projectCollectionJobCompleted, (Object)this.project.getName()), null);
            }
        }
        ResourceSetCommand cmd = new ResourceSetCommand(this.project);
        cmd.addAllProjectResources();
        return cmd.execute(monitor, context, avoidUpdate);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash(this.getProject());
        hcu.hash(this.saveNumber);
        return hcu.getHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectLoadCommand) {
            ProjectLoadCommand command = (ProjectLoadCommand)obj;
            return this.saveNumber == command.saveNumber && (this.project == null ? command.getProject() == null : this.project.equals((Object)command.getProject()));
        }
        return false;
    }

    public String toString() {
        return "ProjectLoadCommand [" + this.project + ", " + this.saveNumber + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput(out);
        su.writeResource((IResource)this.project);
        out.writeInt(this.saveNumber);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalProjectFromStream(this, "project");
        su.readFinalFieldFromStream(this, "saveNumber", Integer.TYPE);
    }

    private class SafeRunnable
    implements ISafeRunnable {
        private IStatus status = null;

        private SafeRunnable() {
        }

        public void handleException(Throwable exception) {
            this.status = Status.CANCEL_STATUS;
        }

        public void run() throws Exception {
            this.status = this.loadProject();
            if (this.status.isOK()) {
                SequentialEventManager mgr = Activator.getDefault().getSequentialEventManager();
                this.status = mgr.loadCommands(ProjectLoadCommand.this.project);
            }
        }

        private IStatus getStatus() {
            return this.status;
        }

        private IStatus loadProject() {
            IStatus status = null;
            Project prj = (Project)Platform.getAdapterManager().loadAdapter((Object)ProjectLoadCommand.this.project, Project.class.getName());
            if (prj == null) {
                return new Status(4, "oracle.eclipse.tools.common.services", "Unable to retrieve project adapter.");
            }
            IDiscoveryStore discoveryStore = prj.getAppService(IDiscoveryStore.class);
            if (discoveryStore == null) {
                return new Status(4, "oracle.eclipse.tools.common.services", "Unable to retrieve discovery store.");
            }
            status = discoveryStore.load(ProjectLoadCommand.this.project, ProjectLoadCommand.this.saveNumber);
            if (status.isOK()) {
                status = DependencyModelManager.getInstance().getModel().load(ProjectLoadCommand.this.project, ProjectLoadCommand.this.saveNumber);
            }
            this.logStatus(status);
            return status;
        }

        private void logStatus(IStatus status) {
            if (status != null) {
                if (status.isMultiStatus() && status instanceof MultiStatus) {
                    IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
                    int n = iStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus child = iStatusArray[n2];
                        this.logStatus(child);
                        ++n2;
                    }
                } else {
                    switch (status.getSeverity()) {
                        case 4: 
                        case 8: {
                            Throwable t = status.getException();
                            if (t != null) {
                                LoggingService.logException((String)status.getPlugin(), (Throwable)t);
                                break;
                            }
                            LoggingService.logError((String)status.getPlugin(), (String)status.getMessage());
                            break;
                        }
                        case 2: {
                            LoggingService.logWarning((String)status.getPlugin(), (String)status.getMessage());
                        }
                    }
                }
            }
        }
    }
}

