/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.project.internal.ProjectManager;
import oracle.eclipse.tools.common.services.resources.ICommand;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

final class ProjectClosedCommand
implements ICommand {
    private static final long serialVersionUID = 1L;
    private final IProject project;
    private final boolean delete;

    ProjectClosedCommand(IProject project, boolean delete) {
        this.project = project;
        this.delete = delete;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor, ITransactionContext context, boolean avoidUpdate) {
        ProjectManager.getInstance().projectClosed(this.project);
        DependencyModelManager.getInstance().getModel().projectClosed(this.project, context);
        if (this.delete) {
            SerializationUtil.deleteSerializedState(this.project);
        }
        return Status.OK_STATUS;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash(this.project);
        hcu.hash(this.delete);
        return hcu.getHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectClosedCommand) {
            ProjectClosedCommand command = (ProjectClosedCommand)obj;
            return this.project.equals((Object)command.getProject()) && this.delete == command.delete;
        }
        return false;
    }

    public String toString() {
        return "ProjectClosedCommand [" + this.project + ", " + this.delete + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput(out);
        su.writeResource((IResource)this.project);
        out.writeBoolean(this.delete);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalProjectFromStream(this, "project");
        su.readFinalFieldFromStream(this, "delete", Boolean.TYPE);
    }
}

