/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import oracle.eclipse.tools.common.services.dependency.model.internal.IDiscoveryStore;
import oracle.eclipse.tools.common.services.dependency.model.internal.ITechnologyDiscoveryStore;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.app.services.AbstractAppService;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class DiscoveryStore
extends AbstractAppService
implements IDiscoveryStore {
    public DiscoveryStore(Project project) {
        super(project);
    }

    @Override
    public IStatus load(IProject project, int saveNumber) {
        MultiStatus ms = new MultiStatus("oracle.eclipse.tools.common.services", 0, "", null);
        for (ITechnologyExtension techExt : this.getProject().getTechnologyExtensions()) {
            ITechnologyDiscoveryStore tdStore = techExt.getAppService(ITechnologyDiscoveryStore.class);
            if (tdStore == null) continue;
            IStatus status = tdStore.load(saveNumber);
            ms.add(status);
            if (!ms.isOK()) break;
        }
        return ms;
    }

    @Override
    public IStatus store(IProject project, int saveNumber, int prevSaveNumber) {
        for (ITechnologyExtension techExt : this.getProject().getTechnologyExtensions()) {
            IStatus status;
            ITechnologyDiscoveryStore tdStore = techExt.getAppService(ITechnologyDiscoveryStore.class);
            if (tdStore == null || (status = tdStore.store(saveNumber, prevSaveNumber)).isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }
}

