/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.Preferences;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class DiscoveryParticipantBuilder {
    private String participantClassName = null;
    private String participantFactoryClassName = null;
    private List<String> dependentTechnologies = null;
    private Expression expression = null;
    private final String pluginID;
    private int priority = 1005;

    public DiscoveryParticipantBuilder(String pluginID) {
        this.pluginID = pluginID;
    }

    public IDiscoveryParticipant build() {
        if (this.participantClassName == null && this.participantFactoryClassName == null) {
            throw new IllegalStateException("Exactly one of participant-class or participant-factory is allowed");
        }
        IDiscoveryParticipant dp = null;
        if (this.participantClassName != null) {
            dp = (IDiscoveryParticipant)PluginUtil.instantiate((String)this.pluginID, (String)this.participantClassName, IDiscoveryParticipant.class);
            if (dp == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Unable to instantiate " + this.participantClassName + " for plugin " + this.pluginID));
            }
        } else {
            Class participantFactoryClass = PluginUtil.loadClass((String)this.pluginID, (String)this.participantFactoryClassName);
            if (participantFactoryClass != null) {
                try {
                    Method getParticipantMethod = participantFactoryClass.getMethod("getParticipant", null);
                    Object participant = getParticipantMethod.invoke(null, null);
                    if (participant instanceof IDiscoveryParticipant) {
                        dp = (IDiscoveryParticipant)participant;
                    } else {
                        LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)(String.valueOf(this.participantFactoryClassName) + "#getParticipant() did not return an instance of IDiscoveryParticipant"));
                    }
                }
                catch (NoSuchMethodException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
            }
        }
        return dp;
    }

    public DiscoveryParticipantBuilder setParticipantClass(String participantClassName) {
        if (this.participantFactoryClassName != null) {
            throw new IllegalStateException("Exactly one of participant-class or participant-factory is allowed");
        }
        this.participantClassName = participantClassName;
        return this;
    }

    public DiscoveryParticipantBuilder setParticipantFactoryClass(String participantFactoryClassName) {
        if (this.participantClassName != null) {
            throw new IllegalStateException("Exactly one of participant-class or participant-factory is allowed");
        }
        this.participantFactoryClassName = participantFactoryClassName;
        return this;
    }

    public DiscoveryParticipantBuilder setEnablementExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public DiscoveryParticipantBuilder setDependentTechnologies(String technologies) {
        this.dependentTechnologies = StringUtil.split((String)technologies, (char)',');
        return this;
    }

    public DiscoveryParticipantBuilder setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isEnabledFor(IProject project) throws CoreException {
        boolean isEnabled = true;
        if (this.expression != null) {
            EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
            evalContext.setAllowPluginActivation(true);
            boolean bl = isEnabled = EvaluationResult.TRUE == this.expression.evaluate((IEvaluationContext)evalContext);
        }
        if (!isEnabled) {
            return false;
        }
        Project prj = (Project)project.getAdapter(Project.class);
        if (prj == null) {
            return false;
        }
        Set<ITechnologyExtension> activeExtensions = prj.getTechnologyExtensions();
        HashMap<String, HashSet<String>> techMap = new HashMap<String, HashSet<String>>(activeExtensions.size(), 1.0f);
        for (ITechnologyExtension ite : activeExtensions) {
            HashSet<String> versionSet = (HashSet<String>)techMap.get(ite.getId());
            if (versionSet == null) {
                versionSet = new HashSet<String>();
                techMap.put(ite.getId(), versionSet);
            }
            versionSet.add(ite.getVersion());
        }
        if (this.dependentTechnologies != null) {
            Activator plugin = Activator.getDefault();
            if (plugin == null) {
                return false;
            }
            Preferences prefs = plugin.getPreferences().getProjectPreferences(project);
            for (String technology : this.dependentTechnologies) {
                int colonIndex = technology.indexOf(58);
                String tech = null;
                String version = null;
                if (colonIndex != -1) {
                    tech = technology.substring(0, colonIndex);
                    version = technology.substring(colonIndex + 1);
                } else {
                    tech = technology;
                }
                Set activeVersions = (Set)techMap.get(tech);
                if (activeVersions == null) {
                    isEnabled = false;
                    break;
                }
                if (version == null) {
                    boolean hasAnyEnabledVersion = false;
                    for (String activeVersion : activeVersions) {
                        if (!prefs.isTechnologyExtensionActiveForDiscovery(tech, activeVersion)) continue;
                        hasAnyEnabledVersion = true;
                        break;
                    }
                    isEnabled &= hasAnyEnabledVersion;
                } else {
                    isEnabled = activeVersions.contains(version) ? (isEnabled &= prefs.isTechnologyExtensionActiveForDiscovery(tech, version)) : false;
                }
                if (!isEnabled) break;
            }
        }
        return isEnabled;
    }
}

