/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.dependency.DependencyMessages;
import oracle.eclipse.tools.common.services.dependency.model.DependencyModelEvent;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.CreateTechnologyChangedListenerCommand;
import oracle.eclipse.tools.common.services.dependency.model.internal.DeleteSaveNumberCommand;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.IDiscoveryStore;
import oracle.eclipse.tools.common.services.dependency.model.internal.ProjectClosedCommand;
import oracle.eclipse.tools.common.services.dependency.model.internal.ProjectLoadCommand;
import oracle.eclipse.tools.common.services.dependency.model.internal.ProjectRefreshCommand;
import oracle.eclipse.tools.common.services.dependency.model.internal.ResourceSetCommand;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.resources.EventType;
import oracle.eclipse.tools.common.services.resources.ICommand;
import oracle.eclipse.tools.common.services.resources.IElementChange;
import oracle.eclipse.tools.common.services.resources.IResourceChange;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEventListener;
import oracle.eclipse.tools.common.services.resources.internal.WorkspaceLoadEvent;
import oracle.eclipse.tools.common.services.transaction.IDataSource;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.transaction.TransactionService;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;

public class DependencyModelManager {
    public static final Object JOB_FAMILY = new Object();
    private static final DependencyModelManager sInstance = new DependencyModelManager();
    private final DependencyModel model = new DependencyModel();
    private final WorkspaceListener workspaceListener = new WorkspaceListener();

    public static final DependencyModelManager getInstance() {
        return sInstance;
    }

    public static IDataSource getDataSource() {
        return DependencyModelManager.getInstance().model.getDataSource();
    }

    private DependencyModelManager() {
    }

    private Set<ICommand> processWorkspaceLoad(WorkspaceLoadEvent event) {
        if (event.getSource() != null && event.getSaveNumber() >= 0) {
            HashSet<ICommand> commands = new HashSet<ICommand>(this.processSavedState(event.getSaveNumber()));
            commands.addAll(this.workspaceListener.resourceChanged(event.getSource()));
            return commands;
        }
        Set<IResourceChange> projectChanges = event.getResourceChanges();
        HashSet<ICommand> commands = new HashSet<ICommand>(projectChanges.size(), 1.0f);
        for (IResourceChange projectChange : projectChanges) {
            IProject project = (IProject)projectChange.getResource();
            if (!project.isAccessible()) continue;
            ResourceSetCommand command = new ResourceSetCommand(project);
            command.addAllProjectResources();
            commands.add(command);
            commands.add(new CreateTechnologyChangedListenerCommand(project));
        }
        return commands;
    }

    private Set<ICommand> processSavedState(int saveNumber) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        HashSet<ICommand> commands = new HashSet<ICommand>(2 * projects.length, 1.0f);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            commands.addAll(this.processProjectSavedState(project, saveNumber));
            ++n2;
        }
        return commands;
    }

    private Set<ICommand> processProjectSavedState(IProject project, int saveNumber) {
        HashSet<ICommand> commands = new HashSet<ICommand>(2, 1.0f);
        commands.add(new ProjectLoadCommand(project, saveNumber));
        commands.add(new DeleteSaveNumberCommand(project));
        return commands;
    }

    public IDependencyModel getModel() {
        return this.model;
    }

    public void refresh(IProgressMonitor monitor) {
        try {
            try {
                this.model.updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.BEFORE_REFRESH, null));
                IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)DependencyMessages.DependencyModelManager_refresh, (int)99);
                        try {
                            final ITransactionContext txContext = TransactionService.getInstance().createTransaction();
                            try {
                                IProject[] projects;
                                DependencyModelManager.this.model.clear(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)24), txContext);
                                DependencyModelManager.this.model.ensureResourceArtifact((IResource)ResourcesPlugin.getWorkspace().getRoot());
                                IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                                int n = projects.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IProject project = iProjectArray[n2];
                                    if (project.isAccessible()) {
                                        try {
                                            project.accept(new IResourceVisitor(){

                                                public boolean visit(IResource resource) throws CoreException {
                                                    if (!resource.isTeamPrivateMember()) {
                                                        DependencyModelManager.this.model.ensureResourceArtifact(resource, txContext);
                                                    }
                                                    return true;
                                                }
                                            });
                                        }
                                        catch (CoreException e) {
                                            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
                                        }
                                        ResourceSetCommand command = new ResourceSetCommand(project);
                                        command.addAllProjectResources();
                                        command.execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)(75 / projects.length)), txContext, true);
                                    }
                                    ++n2;
                                }
                            }
                            finally {
                                TransactionService.getInstance().commit(txContext, monitor);
                            }
                        }
                        finally {
                            ProgressMonitorUtil.done((IProgressMonitor)monitor);
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(runnable, ruleFactory.buildRule(), 1, monitor);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
                this.model.updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.REFRESHED, null));
            }
        }
        finally {
            this.model.updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.REFRESHED, null));
        }
    }

    public void refresh(final IProject project, IProgressMonitor monitor, final ITransactionContext txContext) {
        this.model.updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.BEFORE_REFRESH, project));
        try {
            try {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)DependencyMessages.DependencyModelManager_refresh, (int)99);
                        DependencyModelManager.this.model.clear(project, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)25), txContext);
                        try {
                            project.accept(new IResourceVisitor(){

                                public boolean visit(IResource resource) throws CoreException {
                                    if (!resource.isTeamPrivateMember()) {
                                        DependencyModelManager.this.model.ensureResourceArtifact(resource, txContext);
                                    }
                                    return true;
                                }
                            });
                        }
                        catch (CoreException e) {
                            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
                        }
                        if (project.isAccessible()) {
                            ResourceSetCommand command = new ResourceSetCommand(project);
                            command.addAllProjectResources();
                            command.execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)75), txContext, true);
                        }
                        ProgressMonitorUtil.done((IProgressMonitor)monitor);
                    }
                };
                ResourcesPlugin.getWorkspace().run(runnable, null, 1, monitor);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
                this.model.updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.REFRESHED, project));
            }
        }
        finally {
            this.model.updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.REFRESHED, project));
        }
    }

    @Deprecated
    public static void scheduleRefresh(IProject project) {
        if (project == null) {
            return;
        }
        RefreshJob job = new RefreshJob(project, "");
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.schedule();
    }

    public static ISequentialResourceChangeEventListener getListener() {
        return DependencyModelManager.getInstance().workspaceListener;
    }

    public IStatus storeProject(IProject project, ISaveContext context) {
        int saveNumber = context.getSaveNumber();
        int prevSaveNumber = context.getPreviousSaveNumber();
        IStatus status = null;
        this.deleteSaveNumberFile(project);
        Project prj = (Project)project.getAdapter(Project.class);
        IDiscoveryStore discoveryStore = prj.getAppService(IDiscoveryStore.class);
        if (discoveryStore == null) {
            return new Status(4, "oracle.eclipse.tools.common.services", "Unable to retrieve discovery store.");
        }
        status = discoveryStore.store(project, saveNumber, prevSaveNumber);
        if (status.isOK()) {
            status = this.model.store(project, saveNumber, prevSaveNumber);
        }
        if (status.isOK()) {
            this.writeSaveNumberFile(project, saveNumber);
        } else {
            this.deleteSaveNumberFile(project);
        }
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSaveNumberFile(IProject project, int saveNumber) {
        ObjectOutputStream oos = null;
        try {
            oos = SerializationUtil.getOutputStream(project, "project.num");
            oos.writeInt(saveNumber);
        }
        catch (IOException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
            if (oos == null) return;
            try {
                oos.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (CoreException e) {
            try {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
                if (oos == null) return;
            }
            catch (Throwable throwable) {
                if (oos == null) throw throwable;
                try {
                    oos.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                oos.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * Loose catch block
     */
    private int getSaveNumber(IProject project) {
        ObjectInputStream ois;
        block18: {
            int n;
            block19: {
                ois = null;
                ois = SerializationUtil.getInputStream(project, "project.num");
                if (ois == null) break block18;
                n = ois.readInt();
                if (ois == null) break block19;
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            return n;
        }
        if (ois != null) {
            try {
                ois.close();
            }
            catch (IOException iOException) {}
        }
        return 0;
        catch (IOException e) {
            block20: {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                if (ois == null) break block20;
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            return 0;
        }
        catch (CoreException e2) {
            block21: {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e2);
                if (ois == null) break block21;
                {
                    catch (Throwable throwable) {
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            return 0;
        }
    }

    void deleteSaveNumberFile(IProject project) {
        try {
            boolean deleted;
            File projectSerializationFile = SerializationUtil.getSerializedFile(project, "project.num", false);
            if (projectSerializationFile != null && projectSerializationFile.exists() && !(deleted = projectSerializationFile.delete())) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.common.services", (String)("Unable to delete " + projectSerializationFile.getName()));
            }
        }
        catch (RuntimeException re) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)re);
        }
    }

    private static void logDelta(IResourceDelta delta) {
        if (delta != null) {
            StringBuilder sb = new StringBuilder();
            DependencyModelManager._logDelta("", delta, sb);
            LoggingService.logDebug((String)"oracle.eclipse.tools.common.services", (String)sb.toString());
        }
    }

    private static void _logDelta(String indent, IResourceDelta delta, StringBuilder sb) {
        sb.append("Delta [");
        sb.append(delta.getFullPath().toOSString());
        sb.append(" / ");
        switch (delta.getKind()) {
            case 0: {
                sb.append("NO_CHANGE:");
                break;
            }
            case 1: {
                sb.append("ADDED:");
                break;
            }
            case 2: {
                sb.append("REMOVED:");
                break;
            }
            case 4: {
                sb.append("CHANGED:");
                break;
            }
            case 8: {
                sb.append("ADDED_PHANTOM:");
                break;
            }
            case 16: {
                sb.append("REMOVED_PHANTOM:");
            }
        }
        int flags = delta.getFlags();
        if ((flags & 0x100) != 0) {
            sb.append(" CONTENT ");
        }
        if ((flags & 0x1000) != 0) {
            sb.append(" MOVED_FROM ");
        }
        if ((flags & 0x2000) != 0) {
            sb.append(" MOVED_TO ");
        }
        if ((flags & 0x800) != 0) {
            sb.append(" COPIED_FROM ");
        }
        if ((flags & 0x4000) != 0) {
            sb.append(" OPEN ");
        }
        if ((flags & 0x8000) != 0) {
            sb.append(" TYPE ");
        }
        if ((flags & 0x10000) != 0) {
            sb.append(" SYNC ");
        }
        if ((flags & 0x20000) != 0) {
            sb.append(" MARKERS ");
        }
        if ((flags & 0x40000) != 0) {
            sb.append(" REPLACED ");
        }
        if ((flags & 0x80000) != 0) {
            sb.append(" DESCRIPTION ");
        }
        if ((flags & 0x100000) != 0) {
            sb.append(" ENCODING ");
        }
        if ((flags & 0x200000) != 0) {
            sb.append(" LOCAL_CHANGED ");
        }
        sb.append("]\n");
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            DependencyModelManager._logDelta(String.valueOf(indent) + "\t", child, sb);
            ++n2;
        }
    }

    private static class JavaElementChangeTraversal {
        final List<IProject> changedProjects = new ArrayList<IProject>();

        private JavaElementChangeTraversal() {
        }

        public void traverse(Set<IElementChange> changes) {
            for (IElementChange change : changes) {
                if (change.getKind() != IElementChange.KIND.CHANGED || !change.getFlags().contains((Object)IElementChange.FLAG.F_RESOLVED_CLASSPATH_CHANGED) || change.getElement() == null || change.getElement().getElementType() != 2) continue;
                IJavaProject javaProject = (IJavaProject)change.getElement();
                if (!this.checkForPackageFragmentRoot(change.getDelta())) continue;
                this.changedProjects.add(javaProject.getProject());
            }
        }

        private boolean checkForPackageFragmentRoot(IJavaElementDelta delta) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                if (childDelta.getElement() != null && childDelta.getElement().getElementType() == 3) {
                    if (childDelta.getKind() == 1 || childDelta.getKind() == 2) {
                        return true;
                    }
                    if (childDelta.getKind() == 4 && ((childDelta.getFlags() & 0x80) != 0 || (childDelta.getFlags() & 0x40) != 0)) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }

        public List<IProject> getChangedProjects() {
            return Collections.unmodifiableList(this.changedProjects);
        }
    }

    @Deprecated
    private static class RefreshJob
    extends WorkspaceJob {
        final IProject project;

        RefreshJob(IProject proj, String name) {
            super(name);
            this.project = proj;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ITransactionContext ctx = TransactionService.getInstance().createTransaction();
            try {
                DependencyModelManager.getInstance().refresh(this.project, monitor, ctx);
            }
            finally {
                TransactionService.getInstance().commit(ctx, monitor);
            }
            return Status.OK_STATUS;
        }
    }

    private class WorkspaceListener
    implements ISequentialResourceChangeEventListener {
        @Override
        public Set<ICommand> resourceChanged(ISequentialResourceChangeEvent event) {
            HashSet<ICommand> commands;
            block12: {
                block11: {
                    if (TraceOptions.APPXRAY_RESOURCE_CHANGES && event.getSource() instanceof IResourceChangeEvent) {
                        DependencyModelManager.logDelta(((IResourceChangeEvent)event.getSource()).getDelta());
                    }
                    if (event.getType() == EventType.LOAD) {
                        return DependencyModelManager.this.processWorkspaceLoad((WorkspaceLoadEvent)event);
                    }
                    commands = new HashSet<ICommand>();
                    if (!event.isResourceEvent()) break block11;
                    Set<IResourceChange> resourceChanges = event.getResourceChanges();
                    HashMap<IProject, ResourceSetCommand> projectCommandMap = new HashMap<IProject, ResourceSetCommand>();
                    block4: for (IResourceChange resourceChange : resourceChanges) {
                        IProject project;
                        IResource resource = resourceChange.getResource();
                        if (resource == null || (project = resource.getProject()) == null) continue;
                        if (resource.getType() == 4) {
                            switch (resourceChange.getKind()) {
                                case REMOVED: {
                                    commands.addAll(this.getProjectOpenCloseCommands((IProject)resource, true));
                                    break;
                                }
                                case ADDED: 
                                case CHANGED: {
                                    if (!resourceChange.getFlags().contains((Object)IResourceChange.FLAG.OPEN)) continue block4;
                                    commands.addAll(this.getProjectOpenCloseCommands((IProject)resource, false));
                                    break;
                                }
                            }
                            continue;
                        }
                        ResourceSetCommand projectCommand = (ResourceSetCommand)projectCommandMap.get(project);
                        if (projectCommand == null) {
                            projectCommand = new ResourceSetCommand(project);
                            projectCommandMap.put(project, projectCommand);
                        }
                        projectCommand.addResource(resourceChange);
                    }
                    for (ResourceSetCommand command : projectCommandMap.values()) {
                        if (!command.hasChanges()) continue;
                        commands.add(command);
                    }
                    break block12;
                }
                if (!event.isJavaEvent() || event.getType() != EventType.JAVA_POST_CHANGE) break block12;
                JavaElementChangeTraversal changeTraaversal = new JavaElementChangeTraversal();
                changeTraaversal.traverse(event.getElementChanges());
                for (IProject project : changeTraaversal.getChangedProjects()) {
                    commands.add(this.getProjectRefreshCommand(project));
                }
            }
            return commands;
        }

        public ICommand getProjectRefreshCommand(IProject project) {
            return new ProjectRefreshCommand(project);
        }

        private Set<ICommand> getProjectOpenCloseCommands(IProject project, boolean delete) {
            if (project.isAccessible()) {
                int saveNumber = DependencyModelManager.this.getSaveNumber(project);
                return DependencyModelManager.this.processProjectSavedState(project, saveNumber);
            }
            ProjectClosedCommand command = new ProjectClosedCommand(project, delete);
            return Collections.singleton(command);
        }
    }
}

