/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionParticipant;
import oracle.eclipse.tools.common.services.dependency.model.internal.CollectionParticipantBuilder;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class CollectionParticipantExtensionReader {
    public static final String EXT_PT = "collectionParticipant";
    private static final List<CollectionParticipantBuilder> sPARTICIPANTS;

    static {
        ArrayList<CollectionParticipantBuilder> participants = new ArrayList<CollectionParticipantBuilder>(5);
        try {
            Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.common.services", (String)EXT_PT);
            block3: for (IExtension extension : extensions) {
                IConfigurationElement[] elems;
                IConfigurationElement[] iConfigurationElementArray = elems = extension.getConfigurationElements();
                int n = elems.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement dependentTechnologiesElement;
                    IConfigurationElement collectionParticipantElem = iConfigurationElementArray[n2];
                    CollectionParticipantBuilder builder = new CollectionParticipantBuilder(collectionParticipantElem.getContributor().getName());
                    IConfigurationElement participantClassElement = PluginUtil.findOptionalElement((IConfigurationElement)collectionParticipantElem, (String)"participant-class");
                    IConfigurationElement participantFactoryElement = null;
                    if (participantClassElement == null) {
                        participantFactoryElement = PluginUtil.findOptionalElement((IConfigurationElement)collectionParticipantElem, (String)"participant-factory");
                        if (participantFactoryElement == null) {
                            PluginUtil.reportInvalildElement((IExtension)extension, (IConfigurationElement)collectionParticipantElem);
                            continue block3;
                        }
                        builder.setParticipantFactoryClass(PluginUtil.findRequiredAttribute((IConfigurationElement)participantFactoryElement, (String)"factory-class"));
                    } else {
                        builder.setParticipantClass(PluginUtil.findRequiredAttribute((IConfigurationElement)participantClassElement, (String)"class-name"));
                    }
                    IConfigurationElement enablementElement = PluginUtil.findOptionalElement((IConfigurationElement)collectionParticipantElem, (String)"enablement");
                    Expression expression = null;
                    if (enablementElement != null) {
                        expression = ExpressionConverter.getDefault().perform(enablementElement);
                        builder.setEnablementExpression(expression);
                    }
                    if ((dependentTechnologiesElement = PluginUtil.findOptionalElement((IConfigurationElement)collectionParticipantElem, (String)"dependent-technologies")) != null) {
                        builder.setDependentTechnologies(PluginUtil.findRequiredAttribute((IConfigurationElement)dependentTechnologiesElement, (String)"value"));
                    }
                    participants.add(builder);
                    ++n2;
                }
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)ce);
        }
        catch (PluginUtil.InvalidExtensionException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        sPARTICIPANTS = Collections.unmodifiableList(participants);
    }

    public static Set<ICollectionParticipant> getParticipants(IProject project) {
        LinkedHashSet<ICollectionParticipant> participants = new LinkedHashSet<ICollectionParticipant>(sPARTICIPANTS.size());
        for (CollectionParticipantBuilder builder : sPARTICIPANTS) {
            try {
                ICollectionParticipant newParticipant;
                if (!builder.isEnabledFor(project) || (newParticipant = builder.build()) == null) continue;
                participants.add(newParticipant);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
            }
        }
        return participants;
    }
}

