/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.java.search;

import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.java.search.internal.JavaTypeSearchRequestor;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class JavaTypeManager {
    private static JavaTypeManager sInstance = null;

    public static synchronized JavaTypeManager getInstance() {
        if (sInstance == null) {
            sInstance = new JavaTypeManager();
        }
        return sInstance;
    }

    public Set<IType> search(IJavaSearchScope scope, SearchPattern pattern, IProgressMonitor monitor) throws CoreException {
        SearchEngine engine = new SearchEngine();
        JavaTypeSearchRequestor requestor = new JavaTypeSearchRequestor();
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, monitor);
        return requestor.getMatchedTypes();
    }

    public ITypeHierarchy retrieveTypeHierarchy(IProject project, String qualifiedTypeName, IProgressMonitor monitor) {
        IType type = ClassUtil.getType((String)qualifiedTypeName, (IProject)project);
        if (type == null || !type.exists()) {
            return null;
        }
        try {
            return type.newTypeHierarchy(monitor);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IType[] getAllSubTypes(String superTypeName, IProject project, IProgressMonitor monitor) {
        ITypeHierarchy classHierarchy = this.retrieveTypeHierarchy(project, superTypeName, monitor);
        return classHierarchy != null ? classHierarchy.getAllSubtypes(classHierarchy.getType()) : new IType[]{};
    }
}

