/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.storage.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.MemoryStore;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.MemoryStoreTransaction;
import oracle.eclipse.tools.common.services.transaction.IModificationOperation;
import oracle.eclipse.tools.common.services.transaction.IQuery;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class MemoryStoreTransactionManager {
    private final Map<Long, MemoryStoreTransaction> mTransactions = new LinkedHashMap<Long, MemoryStoreTransaction>();

    MemoryStoreTransactionManager() {
    }

    void start(ITransactionContext context, MemoryStore.MemoryStoreTransactionBridge bridge) {
        long transactionID = context.getTransactionID();
        MemoryStoreTransaction txn = new MemoryStoreTransaction(transactionID, bridge);
        this.mTransactions.put(transactionID, txn);
    }

    void end(ITransactionContext context) {
    }

    IStatus prepare(ITransactionContext context) {
        return Status.OK_STATUS;
    }

    void commit(ITransactionContext context, IProgressMonitor monitor) {
        long transactionID = context.getTransactionID();
        MemoryStoreTransaction txn = this.mTransactions.get(transactionID);
        txn.apply(monitor);
        this.mTransactions.remove(context.getTransactionID());
    }

    void rollback(ITransactionContext context) {
        this.mTransactions.remove(context.getTransactionID());
    }

    void forget(ITransactionContext context) {
        this.mTransactions.remove(context.getTransactionID());
    }

    MemoryStoreTransaction getTransaction(IQuery query) {
        ITransactionContext txCtx = query.getTransactionContext();
        return txCtx == null ? null : this.mTransactions.get(txCtx.getTransactionID());
    }

    MemoryStoreTransaction getTransaction(IModificationOperation operation) {
        ITransactionContext txCtx = operation.getTransactionContext();
        return txCtx == null ? null : this.mTransactions.get(txCtx.getTransactionID());
    }
}

