/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.storage.internal;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ArtifactQuery;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.MultipleArtifactsQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.MemoryStore;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.transaction.InvalidQueryException;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class MemoryStorePersistenceManager {
    private final MemoryStore store;

    MemoryStorePersistenceManager(MemoryStore store) {
        this.store = store;
    }

    /*
     * Exception decompiling
     */
    IStatus load(IProject project, int saveNumber, ITransactionContext ctx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [29[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    IStatus store(IProject project, int saveNumber, int prevSaveNumber, ITransactionContext ctx) {
        ObjectOutputStream oos = null;
        String currFileName = this.getFileName(saveNumber);
        this.deleteFile(project, prevSaveNumber);
        try {
            try {
                oos = SerializationUtil.getOutputStream(project, currFileName);
                ArtifactQuery query = new ArtifactQuery.Builder().setTransactionContext(ctx).setProject(project).build();
                MultipleArtifactsQueryResult queryResult = (MultipleArtifactsQueryResult)this.store.query(query);
                for (IArtifact artifact : queryResult.getArtifacts()) {
                    this.storeArtifact(oos, ctx, artifact);
                }
                oos.writeObject((Object)SerializationUtil.MARKER.END);
                oos.flush();
            }
            catch (IOException e) {
                this.deleteFile(project, saveNumber);
                Status status = new Status(4, "oracle.eclipse.tools.common.services", e.getMessage(), (Throwable)e);
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e2) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e2);
                }
                return status;
            }
            catch (InvalidQueryException e) {
                this.deleteFile(project, saveNumber);
                Status status = new Status(4, "oracle.eclipse.tools.common.services", e.getMessage(), (Throwable)e);
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e3) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e3);
                }
                return status;
            }
            catch (CoreException e) {
                this.deleteFile(project, saveNumber);
                IStatus iStatus = e.getStatus();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e4) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e4);
                }
                return iStatus;
            }
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private final void storeArtifact(ObjectOutputStream oos, ITransactionContext ctx, IArtifact artifact) throws IOException, InvalidQueryException {
        oos.writeObject(artifact);
        ArtifactQuery query = new ArtifactQuery.Builder().setTransactionContext(ctx).setOwner(artifact).build();
        MultipleArtifactsQueryResult queryResult = (MultipleArtifactsQueryResult)this.store.query(query);
        for (IArtifact ownedArtifact : queryResult.getArtifacts()) {
            if (!(ownedArtifact instanceof IVirtualArtifact)) continue;
            this.storeArtifact(oos, ctx, ownedArtifact);
        }
    }

    private void deleteFile(IProject project, int saveNumber) {
        if (saveNumber > 0) {
            String prevFileName = this.getFileName(saveNumber);
            try {
                boolean deleted;
                File projectSerializationFile = SerializationUtil.getSerializedFile(project, prevFileName, false);
                if (projectSerializationFile != null && projectSerializationFile.exists() && !(deleted = projectSerializationFile.delete())) {
                    LoggingService.logDebug((String)"oracle.eclipse.tools.common.services", (String)("Unable to delete " + projectSerializationFile.getName()));
                }
            }
            catch (RuntimeException re) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)re);
            }
        }
    }

    private String getFileName(int saveNumber) {
        return saveNumber + ".artifact.sjo";
    }
}

