/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.storage;

import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.transaction.IQuery;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ArtifactQuery
implements IQuery {
    private final ITransactionContext context;
    private final IArtifact owner;
    private final String name;
    private final String type;
    private final Set<String> artifactTypes;
    private final IProject project;
    private final IArtifact referredArtifact;
    private final IPath path;

    public ArtifactQuery(ITransactionContext context, IArtifact owner, String name, String type, Set<String> artifactTypes, IProject project, IArtifact referredArtifact, IPath path) {
        this.context = context;
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.artifactTypes = artifactTypes;
        this.project = project;
        this.referredArtifact = referredArtifact;
        this.path = path;
    }

    public IArtifact getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getArtifactTypes() {
        return this.artifactTypes;
    }

    public IProject getProject() {
        return this.project;
    }

    public IArtifact getReferredArtifact() {
        return this.referredArtifact;
    }

    public IPath getPath() {
        return this.path;
    }

    @Override
    public ITransactionContext getTransactionContext() {
        return this.context;
    }

    public static class Builder {
        private ITransactionContext context = null;
        private IArtifact owner = null;
        private String name = null;
        private String type = null;
        private Set<String> artifactTypes = null;
        private IProject project = null;
        private IArtifact referredArtifact = null;
        private IPath path = null;

        public ArtifactQuery build() {
            return new ArtifactQuery(this.context, this.owner, this.name, this.type, this.artifactTypes, this.project, this.referredArtifact, this.path);
        }

        public Builder setTransactionContext(ITransactionContext context) {
            this.context = context;
            return this;
        }

        public Builder setOwner(IArtifact owner) {
            this.owner = owner;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setArtifactTypes(Set<String> artifactTypes) {
            this.artifactTypes = artifactTypes;
            return this;
        }

        public Builder setProject(IProject project) {
            this.project = project;
            return this;
        }

        public Builder setReferredArtifact(IArtifact referredArtifact) {
            this.referredArtifact = referredArtifact;
            return this;
        }

        public Builder setPath(IPath path) {
            this.path = path;
            return this;
        }
    }
}

