/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.resource;

import java.net.URL;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.URLArtifact;

public class URLReference
extends AbstractArtifactReference {
    private static final long serialVersionUID = 1L;
    private final URL url;

    public URLReference(URL url, IArtifact source) {
        super(new URLLocator(url), source);
        this.url = url;
    }

    @Override
    public String getName() {
        return this.url.toString();
    }

    @Override
    public String getType() {
        return "url";
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    protected IArtifact createMissingArtifact() {
        return this.getLocator().locateArtifact();
    }

    private static class URLLocator
    implements IArtifactLocator {
        private static final long serialVersionUID = 1L;
        private URLArtifact artifact;

        private URLLocator(URL url) {
            this.artifact = new URLArtifact(url);
        }

        @Override
        public IArtifact locateArtifact() {
            return this.artifact;
        }
    }
}

