/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.resource;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public final class URLArtifact
implements IArtifact,
Serializable {
    private static final long serialVersionUID = 1L;
    private final URL url;

    public URLArtifact(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url can not be null.");
        }
        this.url = url;
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public String getName() {
        return this.url.toExternalForm();
    }

    @Override
    public IArtifact getOwner() {
        return DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)ResourcesPlugin.getWorkspace().getRoot());
    }

    @Override
    public String getType() {
        return "url";
    }

    public String toString() {
        return String.valueOf(this.getType()) + "[" + this.url + "]";
    }

    @Override
    public IProject getProject() {
        return null;
    }

    @Override
    public void addReference(IArtifactReference reference) {
    }

    @Override
    public ResourceLocation getLocation() {
        return null;
    }

    @Override
    public Set<IArtifactReference> getReferences() {
        return Collections.emptySet();
    }

    @Override
    public void removeReferences(String collectorID, ITransactionContext txContext) {
    }

    @Override
    public void removeReferences() {
    }

    @Override
    public IResource[] getAffectedResources() {
        return new IResource[0];
    }
}

