/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.resource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IResource;

public final class ResourceReference
extends AbstractArtifactReference
implements IArtifactReference,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IResource refereeResource;
    private volatile transient int hashCode = 0;

    public ResourceReference(IArtifact owner, ResourceLocation referenceLocation, IResource refereeResource, String collectorID) {
        super(new ResourceArtifactLocator(refereeResource), owner);
        this.refereeResource = refereeResource;
        this.addLocation(new ArtifactReferenceLocation(referenceLocation, true, collectorID));
    }

    protected ResourceReference(IArtifact owner, IResource refereeResource) {
        super(new ResourceArtifactLocator(refereeResource), owner);
        this.refereeResource = refereeResource;
    }

    @Override
    public String getName() {
        switch (this.refereeResource.getType()) {
            case 4: 
            case 8: {
                return this.refereeResource.getName();
            }
        }
        return this.refereeResource.getProjectRelativePath().toString();
    }

    @Override
    public String getType() {
        return "resource";
    }

    @Override
    public boolean isMissing() {
        return this.refereeResource == null || !this.refereeResource.exists();
    }

    public IResource getRefereeResource() {
        return this.refereeResource;
    }

    @Override
    public boolean refersTo(IArtifact artifact) {
        IResource refereeResource = this.getRefereeResource();
        return artifact instanceof ResourceArtifact && refereeResource != null && refereeResource.equals((Object)artifact.getLocation().getResource());
    }

    @Override
    protected IArtifact createMissingArtifact() {
        IResource refereeResource = this.getRefereeResource();
        return new ResourceArtifact(refereeResource);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ResourceReference) {
            boolean refereeResourceIsEqual;
            ResourceReference otherRef = (ResourceReference)object;
            if (this.refereeResource != null) {
                refereeResourceIsEqual = this.refereeResource.equals((Object)otherRef.refereeResource);
            } else {
                boolean bl = refereeResourceIsEqual = otherRef.refereeResource == null;
            }
            return super.equals(object) && refereeResourceIsEqual;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash(this.refereeResource);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput(out);
        su.writeResource(this.refereeResource);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, PrivilegedActionException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalResourceFromStream(this, "refereeResource");
    }

    private static final class ResourceArtifactLocator
    implements IArtifactLocator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final IResource refereeResource;
        private volatile transient int hashCode = 0;

        public ResourceArtifactLocator(IResource refereeResource) {
            if (refereeResource == null) {
                throw new IllegalStateException("refereeResource can not be null.");
            }
            this.refereeResource = refereeResource;
        }

        @Override
        public IArtifact locateArtifact() {
            return DependencyModelManager.getInstance().getModel().ensureResourceArtifact(this.refereeResource);
        }

        public boolean equals(Object other) {
            if (other instanceof ResourceArtifactLocator) {
                return this.refereeResource.equals((Object)((ResourceArtifactLocator)other).refereeResource);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                HashCodeUtil hcu = HashCodeUtil.newInstance();
                hcu.hash(this.refereeResource);
                this.hashCode = hcu.getHashCode();
            }
            return this.hashCode;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            SerializationUtil su = SerializationUtil.forOutput(out);
            su.writeResource(this.refereeResource);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, PrivilegedActionException, IllegalAccessException {
            SerializationUtil su = SerializationUtil.forInput(in);
            su.readFinalResourceFromStream(this, "refereeResource");
            if (this.refereeResource == null) {
                throw new IllegalStateException("Corrupted data stream.");
            }
        }
    }
}

