/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.resource;

import java.io.ObjectStreamException;
import java.io.Serializable;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public final class ResourceArtifact
extends AbstractArtifact
implements IArtifact,
Serializable {
    private static final long serialVersionUID = 1L;

    public ResourceArtifact(IResource resource) {
        super(new ResourceLocation(resource, null));
    }

    @Override
    public boolean isMissing() {
        return !this.getLocation().getResource().isAccessible();
    }

    @Override
    public String getName() {
        return this.getLocation().getResource().getFullPath().toPortableString();
    }

    @Override
    public IArtifact getOwner() {
        IResource resource = this.getLocation().getResource();
        if (resource.getType() == 8) {
            return null;
        }
        if (resource.isAccessible()) {
            IContainer parent = resource.getParent();
            if (parent == null) {
                return null;
            }
            ResourceArtifact owner = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)parent);
            return owner;
        }
        IContainer parent = resource.getParent();
        if (parent == null) {
            return null;
        }
        IPath parentPath = parent.getFullPath();
        return DependencyModelManager.getInstance().getModel().queryArtifactByPath(parentPath);
    }

    @Override
    public String getType() {
        return "resource";
    }

    @Override
    public String toString() {
        return String.valueOf(this.getType()) + "[" + this.getLocation().getResource() + "]";
    }

    @Override
    public IProject getProject() {
        return this.getLocation().getResource().getProject();
    }

    private Object readResolve() throws ObjectStreamException {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        ResourceLocation location = this.getLocation();
        if (model != null && location != null) {
            if (location.getResource() == null) {
                throw new IllegalStateException("Corrupted data stream.");
            }
            ResourceArtifact resolvedArtifact = model.ensureResourceArtifact(location.getResource());
            if (resolvedArtifact != null) {
                resolvedArtifact.addTempReferences(this.tempRefStorePostDeserialization);
                return resolvedArtifact;
            }
        }
        return this;
    }

    @Override
    public IResource[] getAffectedResources() {
        IResource resource = this.getLocation().getResource();
        return new IResource[]{resource};
    }
}

