/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.internal;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactCategoryManager;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactTypeFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactCategory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ArtifactException;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModelListener;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ArtifactControllerImpl
implements ArtifactController {
    private final IDependencyModel model;
    private final Set<ArtifactTypeFilter> typeFilters;

    public ArtifactControllerImpl(IDependencyModel model) {
        this.model = model;
        this.typeFilters = ArtifactCategoryManager.getFilters();
    }

    @Override
    public Set<IArtifact> getArtifactChildren(IArtifact artifact) {
        return this.model.queryArtifactsByOwner(artifact);
    }

    @Override
    public Set<IArtifactReference> getArtifactReferers(IArtifact artifact) {
        return this.model.queryArtifactsByReferredArtifact(artifact);
    }

    @Override
    public IArtifact[] getRoots(IArtifact artifact) throws ArtifactException {
        return null;
    }

    @Override
    public ResourceArtifact[] getRoots(ResourceArtifact resourceArtifact) throws ArtifactException {
        return null;
    }

    @Override
    public boolean isRootSrcFolder(IResource folder) {
        return false;
    }

    @Override
    public boolean isSourceFile(ResourceArtifact resourceArtifact) {
        return false;
    }

    @Override
    public boolean isSourceFile(IFile definitionFile) {
        return false;
    }

    @Override
    public Set<IArtifactCategory> getAllCategories(IProject project) {
        LinkedHashSet<IArtifactCategory> allCategories = new LinkedHashSet<IArtifactCategory>();
        Set<IArtifactCategory> cats = ArtifactCategoryManager.getAllCategories();
        for (IArtifactCategory cat : cats) {
            try {
                if (!cat.isEnabledFor(project)) continue;
                allCategories.add(cat);
            }
            catch (CoreException ce) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)ce);
            }
        }
        return allCategories;
    }

    @Override
    public Set<IArtifact> getAllArtifactsInCategory(IArtifactCategory category, IProject project) {
        Set<String> includedTypes = category.getIncludedTypes();
        return this.model.queryArtifactsByTypes(includedTypes, project);
    }

    @Override
    public Set<ArtifactTypeFilter> getFilters(IProject project) {
        LinkedHashSet<ArtifactTypeFilter> res = new LinkedHashSet<ArtifactTypeFilter>(this.typeFilters.size(), 1.0f);
        for (ArtifactTypeFilter filter : this.typeFilters) {
            try {
                if (!filter.isEnabledFor(project)) continue;
                res.add(filter);
            }
            catch (CoreException ce) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)ce);
            }
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public IArtifactCategory getCategoryFor(IArtifact artifact) {
        return ArtifactCategoryManager.categoryFor(artifact);
    }

    @Override
    public Set<IArtifactCategory> getChildCategories(IArtifact artifact) {
        return ArtifactCategoryManager.getChildCategoriesFor(artifact.getType());
    }

    @Override
    public void addListener(IDependencyModelListener listener) {
        this.model.addListener(listener);
    }

    @Override
    public void removeListener(IDependencyModelListener listener) {
        this.model.removeListener(listener);
    }
}

