/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.internal;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactCategoryManager;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactCategory;
import oracle.eclipse.tools.common.util.PluginUtil;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ArtifactCategory
implements IArtifactCategory {
    private final String id;
    private final String parentCategoryID;
    private IArtifactCategory parentCategory = null;
    private final String parentArtifactType;
    private Set<IArtifactCategory> subCategories = null;
    private final Set<String> subCategoriesIDs;
    private final Set<String> includedTypes;
    private final Expression expression;

    public ArtifactCategory(IConfigurationElement artifactCategoryElem, Expression expression) throws PluginUtil.InvalidExtensionException {
        this.id = PluginUtil.findRequiredAttribute((IConfigurationElement)artifactCategoryElem, (String)"category-id");
        IConfigurationElement parentElem = PluginUtil.findRequiredElement((IConfigurationElement)artifactCategoryElem, (String)"parent");
        IConfigurationElement parentArtifactElem = PluginUtil.findOptionalElement((IConfigurationElement)parentElem, (String)"artifact");
        IConfigurationElement parentCategoryElem = PluginUtil.findOptionalElement((IConfigurationElement)parentElem, (String)"category");
        if (parentArtifactElem == null && parentCategoryElem == null) {
            PluginUtil.reportMissingElement((IConfigurationElement)parentElem, (String)"[artifact | category]");
            throw new PluginUtil.InvalidExtensionException();
        }
        if (parentArtifactElem != null) {
            this.parentArtifactType = PluginUtil.findRequiredAttribute((IConfigurationElement)parentArtifactElem, (String)"id");
            this.parentCategoryID = null;
        } else {
            this.parentCategoryID = PluginUtil.findRequiredAttribute((IConfigurationElement)parentCategoryElem, (String)"id");
            this.parentArtifactType = null;
        }
        IConfigurationElement[] artifactTypeElems = artifactCategoryElem.getChildren("artifact-type");
        LinkedHashSet<String> types = new LinkedHashSet<String>(artifactTypeElems.length, 1.0f);
        IConfigurationElement[] iConfigurationElementArray = artifactTypeElems;
        int n = artifactTypeElems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement artifactTypeElem = iConfigurationElementArray[n2];
            String typeID = PluginUtil.findRequiredAttribute((IConfigurationElement)artifactTypeElem, (String)"type-id");
            types.add(typeID);
            ++n2;
        }
        this.includedTypes = Collections.unmodifiableSet(types);
        IConfigurationElement[] subCategoryElems = artifactCategoryElem.getChildren("sub-category");
        LinkedHashSet<String> subCats = new LinkedHashSet<String>(subCategoryElems.length, 1.0f);
        IConfigurationElement[] iConfigurationElementArray2 = subCategoryElems;
        int n3 = subCategoryElems.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement subCategoryElem = iConfigurationElementArray2[n4];
            String catID = PluginUtil.findRequiredAttribute((IConfigurationElement)subCategoryElem, (String)"id");
            subCats.add(catID);
            ++n4;
        }
        this.subCategoriesIDs = Collections.unmodifiableSet(subCats);
        this.expression = expression;
    }

    @Override
    public String getParentArtifactType() throws IllegalStateException {
        if (this.parentArtifactType == null) {
            throw new IllegalStateException();
        }
        return this.parentArtifactType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IArtifactCategory getParentCategory() throws IllegalStateException {
        if (this.parentCategoryID == null) {
            throw new IllegalStateException();
        }
        String string = this.parentCategoryID;
        synchronized (string) {
            if (this.parentCategory == null) {
                this.parentCategory = ArtifactCategoryManager.categoryFor(this.parentCategoryID);
            }
        }
        return this.parentCategory;
    }

    @Override
    public IArtifactCategory.PARENT_TYPE getParentType() {
        return this.parentCategoryID == null ? IArtifactCategory.PARENT_TYPE.ARTIFACT : IArtifactCategory.PARENT_TYPE.CATEGORY;
    }

    @Override
    public String getCategoryId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IArtifactCategory> getChildCategories() throws IllegalArgumentException {
        Set<String> set = this.subCategoriesIDs;
        synchronized (set) {
            if (this.subCategories == null) {
                this.subCategories = new LinkedHashSet<IArtifactCategory>(this.subCategoriesIDs.size());
                for (String catID : this.subCategoriesIDs) {
                    IArtifactCategory cat = ArtifactCategoryManager.categoryFor(catID);
                    this.subCategories.add(cat);
                }
            }
        }
        return this.subCategories;
    }

    @Override
    public Set<String> getIncludedTypes() {
        return this.includedTypes;
    }

    @Override
    public boolean isEnabledFor(IProject project) throws CoreException {
        if (this.expression == null) {
            return true;
        }
        EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
        evalContext.setAllowPluginActivation(true);
        return EvaluationResult.TRUE == this.expression.evaluate((IEvaluationContext)evalContext);
    }

    public String toString() {
        return this.getCategoryId();
    }
}

