/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.collection;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionFilter;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class ContentTypeCollectionFilter
implements ICollectionFilter {
    private final Set<String> contentTypeIDs;

    public ContentTypeCollectionFilter(Set<String> contentTypeIDs) {
        this.contentTypeIDs = Collections.unmodifiableSet(contentTypeIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean match(IResourceContext context) {
        IResourceContext iResourceContext = context;
        synchronized (iResourceContext) {
            return this.matches(context.getContentTypeId());
        }
    }

    @Override
    public boolean match(IResource resource) {
        try {
            IContentType contentType;
            IContentDescription contentDesc;
            if (resource != null && resource.isAccessible() && resource.isSynchronized(0) && 1 == resource.getType() && (contentDesc = ((IFile)resource).getContentDescription()) != null && (contentType = contentDesc.getContentType()) != null) {
                return this.matches(contentType.getId());
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)ce);
        }
        return false;
    }

    private boolean matches(String contentTypeId) {
        return this.contentTypeIDs.contains(contentTypeId);
    }
}

