/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IReferenceCountArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class TypeArtifact
extends AbstractArtifact
implements IReferenceCountArtifact,
IAdaptable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "type";
    private final TypeHandle typeHandle;
    private int refCount = 0;

    public TypeArtifact(String typeName, IProject project) {
        super(null);
        this.typeHandle = new TypeHandle(typeName, project);
    }

    @Override
    public ResourceLocation getLocation() {
        IType type;
        ISourceRange sourceRange;
        IResource res;
        block5: {
            res = this.typeHandle.getResource();
            if (res == null) {
                return null;
            }
            sourceRange = null;
            try {
                type = this.typeHandle.findType();
                if (type != null) break block5;
                return null;
            }
            catch (JavaModelException javaModelException) {}
        }
        sourceRange = type.getSourceRange();
        Range range = null;
        if (sourceRange != null && sourceRange.getLength() > 0 && sourceRange.getOffset() > -1) {
            range = new Range(sourceRange.getOffset(), sourceRange.getLength());
        }
        return new ResourceLocation(res, range);
    }

    @Override
    public boolean isMissing() {
        return this.typeHandle.isMissing();
    }

    @Override
    public final String getName() {
        return this.typeHandle.getTypeName();
    }

    @Override
    public IArtifact getOwner() {
        return DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)this.typeHandle.getProject());
    }

    @Override
    public final String getType() {
        return TYPE;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TypeArtifact) {
            TypeArtifact artifact = (TypeArtifact)object;
            return this.typeHandle.equals(artifact.typeHandle);
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash(this.typeHandle);
        return hcu.getHashCode();
    }

    @Override
    public IProject getProject() {
        return this.typeHandle.getProject();
    }

    public Object getAdapter(Class adapter) {
        if (IType.class.isAssignableFrom(adapter)) {
            return this.typeHandle == null ? null : this.typeHandle.findType();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public String toString() {
        return new StringBuffer(this.getType()).append("[").append(this.getName()).append("]").toString();
    }

    @Override
    public void decrementReferenceCount() {
        --this.refCount;
    }

    @Override
    public boolean hasZeroReferences() {
        return this.refCount <= 0;
    }

    @Override
    public void incrementReferenceCount() {
        ++this.refCount;
    }

    @Override
    public IResource[] getAffectedResources() {
        IResource resource = this.typeHandle.getResource();
        if (resource != null) {
            return new IResource[]{resource};
        }
        return new IResource[0];
    }

    private static final class TypeHandle
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String typeName;
        private final IProject project;
        private IType type = null;

        public TypeHandle(String typeName, IProject project) {
            this.project = project;
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public IProject getProject() {
            return this.project;
        }

        public boolean isMissing() {
            IType javaType = this.findType();
            return javaType == null || !javaType.exists();
        }

        public IResource getResource() {
            IType aType = this.findType();
            try {
                return aType == null ? null : aType.getUnderlyingResource();
            }
            catch (JavaModelException jme) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)((Object)jme));
                return null;
            }
        }

        public boolean equals(Object other) {
            if (other instanceof TypeHandle) {
                TypeHandle th = (TypeHandle)other;
                return (this.project == null ? th.getProject() == null : this.project.equals((Object)th.getProject())) && (this.typeName == null ? th.getTypeName() == null : this.typeName.equals(th.getTypeName()));
            }
            return false;
        }

        public int hashCode() {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(this.project);
            hcu.hash(this.typeName);
            return hcu.getHashCode();
        }

        private synchronized IType findType() {
            if (this.type == null) {
                try {
                    IJavaProject jProj = JavaCore.create((IProject)this.project);
                    this.type = jProj.findType(this.typeName);
                }
                catch (JavaModelException jme) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)((Object)jme));
                }
            }
            return this.type;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            SerializationUtil su = SerializationUtil.forOutput(out);
            su.writeResource((IResource)this.project);
            out.writeObject(this.typeName);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, PrivilegedActionException, IllegalAccessException {
            SerializationUtil su = SerializationUtil.forInput(in);
            su.readFinalProjectFromStream(this, "project");
            su.readFinalFieldFromStream(this, "typeName", String.class);
        }
    }
}

