/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.dependency.DependencyMessages;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class ResourceLocation
implements Serializable {
    static final long serialVersionUID = 1L;
    private final IResource resource;
    private final Range range;
    private volatile transient int hashCode = 0;

    public ResourceLocation(IResource resource, Range range) {
        assert (resource != null);
        this.resource = resource;
        this.range = range;
    }

    public IResource getResource() {
        return this.resource;
    }

    public Range getRange() {
        return this.range;
    }

    public String toString() {
        return String.valueOf(this.resource == null ? DependencyMessages.unknownResource : this.resource.getFullPath().toString()) + " @ (" + (this.range == null ? DependencyMessages.unknownRange : this.range.toString()) + ")";
    }

    public boolean equals(Object object) {
        ResourceLocation otherLocation;
        if (object instanceof ResourceLocation && this.resource.equals((Object)(otherLocation = (ResourceLocation)object).getResource())) {
            return this.range == null ? otherLocation.getRange() == null : this.range.equals(otherLocation.getRange());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(this.resource);
            hcu.hash(this.range);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    public IMarker createProblemMarker(String message, int severity) {
        try {
            IMarker marker = this.resource.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            marker.setAttribute("charStart", this.range != null ? (int)this.range.getOffset() : -1);
            marker.setAttribute("charEnd", this.range != null ? (int)this.range.getEndOffset() : -1);
            return marker;
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
            return null;
        }
    }

    public static ResourceLocation fromDOMElement(IFile file, IDOMElement owningElem) {
        IStructuredDocumentRegion startRegion = owningElem.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endRegion = owningElem.getEndStructuredDocumentRegion();
        if (startRegion != null) {
            if (endRegion != null) {
                int start = startRegion.getStartOffset();
                return new ResourceLocation((IResource)file, new Range(start, endRegion.getEndOffset() - start));
            }
            int start = startRegion.getStartOffset();
            return new ResourceLocation((IResource)file, new Range(start, startRegion.getEndOffset() - start));
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput(out);
        su.writeResource(this.resource);
        out.writeObject(this.range);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, PrivilegedActionException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalResourceFromStream(this, "resource");
        if (this.resource == null) {
            throw new IllegalStateException("Corrupted stream data.");
        }
        su.readFinalFieldFromStream(this, "range", Range.class);
    }
}

