/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.io.Serializable;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;

public class ArtifactReferenceLocation
implements IArtifactReferenceLocation,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean visible;
    private final ResourceLocation location;
    private final String artifactCollectorID;
    private volatile transient int hashCode = 0;

    public ArtifactReferenceLocation(IArtifactReferenceLocation location) {
        this(location.getResourceLocation(), location.isVisible(), location.getArtifactCollectorID());
    }

    public ArtifactReferenceLocation(ResourceLocation location, boolean visible, String collectorID) {
        this.location = location;
        this.visible = visible;
        this.artifactCollectorID = collectorID;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public String getArtifactCollectorID() {
        return this.artifactCollectorID;
    }

    public boolean equals(Object object) {
        if (object instanceof ArtifactReferenceLocation) {
            ArtifactReferenceLocation otherLocation = (ArtifactReferenceLocation)object;
            return this.location.equals(otherLocation.getResourceLocation()) && this.visible == otherLocation.isVisible() && this.artifactCollectorID == otherLocation.getArtifactCollectorID();
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(this.visible);
            hcu.hash(this.location);
            hcu.hash(this.artifactCollectorID);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return new StringBuffer("[").append(this.location).append("] visible = [").append(this.visible).append("] collected by [").append(this.artifactCollectorID).append("]").toString();
    }
}

