/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactTypeFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactCategory;
import oracle.eclipse.tools.common.services.dependency.artifact.internal.ArtifactCategory;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ArtifactCategoryManager {
    private static final String EXT_PT = "oracle.eclipse.tools.common.services.artifact";
    private static final String ARTIFACT_DEF = "artifact-definition";
    private static final String ARTIFACT_CATEGORY = "artifact-category";
    private static final String ARTIFACT_FILTER = "artifact-filter";
    private static final String CATEGORIES = "categories";
    private static final String FILTERS = "filters";
    private static final String ENABLEMENT = "enablement";
    public static final String ROOT = "ROOT";
    private static final Map<String, IArtifactCategory> sARTIFACT_CATEGORIES;
    private static final Map<String, ArtifactTypeFilter> sARTIFACT_FILTERS;
    private static final Map<String, Set<IArtifactCategory>> sARTIFACT_PARENTS;
    private static RootCategory Root;

    static {
        Root = new RootCategory();
        LinkedHashMap<String, LinkedHashSet<ArtifactCategory>> artifactToSubCategories = new LinkedHashMap<String, LinkedHashSet<ArtifactCategory>>();
        LinkedHashMap<String, ArtifactCategory> categories = new LinkedHashMap<String, ArtifactCategory>();
        LinkedHashMap<String, ArtifactTypeFilter> filters = new LinkedHashMap<String, ArtifactTypeFilter>();
        sARTIFACT_CATEGORIES = Collections.unmodifiableMap(categories);
        sARTIFACT_FILTERS = Collections.unmodifiableMap(filters);
        sARTIFACT_PARENTS = Collections.unmodifiableMap(artifactToSubCategories);
        try {
            IConfigurationElement[] configElems;
            IConfigurationElement[] iConfigurationElementArray = configElems = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_PT);
            int n = configElems.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                IConfigurationElement[] iConfigurationElementArray2;
                IConfigurationElement enablementElem;
                IConfigurationElement configElem = iConfigurationElementArray[n2];
                if (configElem.getName().equals(ARTIFACT_DEF)) {
                    boolean isRoot;
                    String type = PluginUtil.findRequiredAttribute((IConfigurationElement)configElem, (String)"type-id");
                    boolean bl = isRoot = configElem.getAttribute("isRoot") == null ? false : Boolean.valueOf(configElem.getAttribute("isRoot"));
                    if (isRoot) {
                        Root.addRootType(type);
                    }
                } else if (configElem.getName().equals(CATEGORIES)) {
                    IConfigurationElement[] artifactCategories;
                    enablementElem = PluginUtil.findOptionalElement((IConfigurationElement)configElem, (String)ENABLEMENT);
                    Expression expr = null;
                    if (enablementElem != null) {
                        expr = ExpressionConverter.getDefault().perform(enablementElem);
                    }
                    iConfigurationElementArray2 = artifactCategories = configElem.getChildren(ARTIFACT_CATEGORY);
                    n4 = artifactCategories.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IConfigurationElement artifactCategoryElem = iConfigurationElementArray2[n3];
                        ArtifactCategory cat = new ArtifactCategory(artifactCategoryElem, expr);
                        categories.put(cat.getCategoryId(), cat);
                        if (cat.getParentType() == IArtifactCategory.PARENT_TYPE.CATEGORY && cat.getParentCategory() == Root) {
                            Root.addRootCategory(cat);
                        } else if (cat.getParentType() == IArtifactCategory.PARENT_TYPE.ARTIFACT) {
                            LinkedHashSet<ArtifactCategory> cats = (LinkedHashSet<ArtifactCategory>)artifactToSubCategories.get(cat.getParentArtifactType());
                            if (cats == null) {
                                cats = new LinkedHashSet<ArtifactCategory>();
                                artifactToSubCategories.put(cat.getParentArtifactType(), cats);
                            }
                            cats.add(cat);
                        }
                        ++n3;
                    }
                } else if (configElem.getName().equals(FILTERS)) {
                    IConfigurationElement[] artifactFilters;
                    enablementElem = PluginUtil.findOptionalElement((IConfigurationElement)configElem, (String)ENABLEMENT);
                    Expression expr = null;
                    if (enablementElem != null) {
                        expr = ExpressionConverter.getDefault().perform(enablementElem);
                    }
                    iConfigurationElementArray2 = artifactFilters = configElem.getChildren(ARTIFACT_FILTER);
                    n4 = artifactFilters.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IConfigurationElement artifactFilterElem = iConfigurationElementArray2[n3];
                        ArtifactTypeFilter filter = new ArtifactTypeFilter(artifactFilterElem, expr);
                        filters.put(PluginUtil.findRequiredAttribute((IConfigurationElement)artifactFilterElem, (String)"filter-id"), filter);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
        }
        catch (PluginUtil.InvalidExtensionException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
    }

    public static IArtifactCategory categoryFor(String categoryID) throws IllegalArgumentException {
        if (ROOT.equals(categoryID)) {
            return Root;
        }
        IArtifactCategory result = sARTIFACT_CATEGORIES.get(categoryID);
        if (result == null) {
            throw new IllegalArgumentException("Undefined category " + categoryID);
        }
        return result;
    }

    public static IArtifactCategory categoryFor(IArtifact artifact) {
        String artifactType = artifact.getType();
        if (Root.getIncludedTypes().contains(artifactType)) {
            return Root;
        }
        for (IArtifactCategory cat : sARTIFACT_CATEGORIES.values()) {
            if (!cat.getIncludedTypes().contains(artifactType)) continue;
            return cat;
        }
        return null;
    }

    public static Set<IArtifactCategory> getChildCategoriesFor(String artifactID) {
        Set<IArtifactCategory> cats = sARTIFACT_PARENTS.get(artifactID);
        if (cats == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(cats);
    }

    public static Set<IArtifactCategory> getAllCategories() {
        return Collections.unmodifiableSet(new LinkedHashSet<IArtifactCategory>(sARTIFACT_CATEGORIES.values()));
    }

    public static Set<ArtifactTypeFilter> getFilters() {
        return Collections.unmodifiableSet(new LinkedHashSet<ArtifactTypeFilter>(sARTIFACT_FILTERS.values()));
    }

    private static class RootCategory
    implements IArtifactCategory {
        private final Set<IArtifactCategory> subCats = new LinkedHashSet<IArtifactCategory>();
        private final Set<String> includedTypes = new LinkedHashSet<String>();

        private RootCategory() {
        }

        @Override
        public String getCategoryId() {
            return ArtifactCategoryManager.ROOT;
        }

        @Override
        public Set<IArtifactCategory> getChildCategories() {
            return this.subCats;
        }

        @Override
        public String getParentArtifactType() throws IllegalStateException {
            return null;
        }

        @Override
        public IArtifactCategory getParentCategory() throws IllegalStateException {
            return null;
        }

        @Override
        public IArtifactCategory.PARENT_TYPE getParentType() {
            return IArtifactCategory.PARENT_TYPE.CATEGORY;
        }

        @Override
        public Set<String> getIncludedTypes() {
            return Collections.unmodifiableSet(this.includedTypes);
        }

        public void addRootCategory(IArtifactCategory cat) {
            this.subCats.add(cat);
        }

        public void addRootType(String type) {
            this.includedTypes.add(type);
        }

        @Override
        public boolean isEnabledFor(IProject project) {
            return true;
        }
    }
}

