/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;

public abstract class AbstractArtifactReference
implements IArtifactReference,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IArtifact source;
    private final IArtifactLocator targetArtifactLocator;
    private final Map<String, Set<IArtifactReferenceLocation>> referenceLocations = new LinkedHashMap<String, Set<IArtifactReferenceLocation>>();
    private volatile transient int hashCode = 0;

    protected AbstractArtifactReference(IArtifactLocator targetArtifactLocator, IArtifact source) {
        this.targetArtifactLocator = targetArtifactLocator;
        this.source = source;
    }

    @Override
    public final synchronized void addLocation(IArtifactReferenceLocation location) {
        this.addLocations(Collections.singleton(location));
    }

    @Override
    public synchronized void addLocations(Set<IArtifactReferenceLocation> locations) {
        for (IArtifactReferenceLocation location : locations) {
            String collectorID = location.getArtifactCollectorID();
            Set<IArtifactReferenceLocation> existingLocations = this.referenceLocations.get(collectorID);
            if (existingLocations == null) {
                existingLocations = new LinkedHashSet<IArtifactReferenceLocation>();
                this.referenceLocations.put(collectorID, existingLocations);
            }
            existingLocations.add(location);
        }
    }

    @Override
    public synchronized void removeLocation(IArtifactReferenceLocation location) {
        this.removeLocations(Collections.singleton(location));
    }

    @Override
    public synchronized void removeLocations(Set<IArtifactReferenceLocation> locations) {
        for (IArtifactReferenceLocation location : locations) {
            String collectorID = location.getArtifactCollectorID();
            Set<IArtifactReferenceLocation> existingLocations = this.referenceLocations.get(collectorID);
            if (existingLocations == null) continue;
            existingLocations.remove(location);
            if (!existingLocations.isEmpty()) continue;
            this.referenceLocations.remove(collectorID);
        }
    }

    @Override
    public synchronized void removeLocations(String collectorID) {
        this.referenceLocations.remove(collectorID);
    }

    @Override
    public IArtifact getTargetArtifact() {
        IArtifact targetArtifact = this.getLocator().locateArtifact();
        return targetArtifact == null ? this.createMissingArtifact() : targetArtifact;
    }

    @Override
    public IArtifact getOwner() {
        return this.source;
    }

    @Override
    public synchronized Set<IArtifactReferenceLocation> getLocations() {
        LinkedHashSet<IArtifactReferenceLocation> allLocations = new LinkedHashSet<IArtifactReferenceLocation>();
        for (Set<IArtifactReferenceLocation> locations : this.referenceLocations.values()) {
            allLocations.addAll(locations);
        }
        return Collections.unmodifiableSet(allLocations);
    }

    @Override
    public boolean refersTo(IArtifact artifact) {
        IArtifact targetArtifact = this.getLocator().locateArtifact();
        return targetArtifact == null ? false : targetArtifact.equals(artifact);
    }

    @Override
    public IArtifactLocator getLocator() {
        return this.targetArtifactLocator;
    }

    protected abstract IArtifact createMissingArtifact();

    @Override
    public boolean isTargetDefinedByReferringSource() {
        return false;
    }

    @Override
    public void dispose(ITransactionContext txContext) {
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractArtifactReference) {
            boolean locatorIsEqual;
            boolean sourceIsEqual;
            AbstractArtifactReference otherRef = (AbstractArtifactReference)object;
            if (this.source != null) {
                sourceIsEqual = this.source.equals(otherRef.source);
            } else {
                boolean bl = sourceIsEqual = otherRef.source == null;
            }
            if (this.getLocator() != null) {
                locatorIsEqual = this.getLocator().equals(otherRef.getLocator());
            } else {
                boolean bl = locatorIsEqual = otherRef.getLocator() == null;
            }
            return sourceIsEqual && locatorIsEqual;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(this.targetArtifactLocator);
            hcu.hash(this.source);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean canMerge(IArtifactReference reference) {
        return this.getLocator().equals(reference.getLocator());
    }

    @Override
    public void merge(IArtifactReference reference) {
        this.addLocations(reference.getLocations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType());
        sb.append("[");
        sb.append(this.getOwner());
        sb.append("->");
        sb.append(this.getTargetArtifact());
        sb.append("]");
        return sb.toString();
    }
}

