/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IProject;

public abstract class AbstractArtifact
implements IArtifact,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ResourceLocation location;
    protected final Set<IArtifactReference> references = new LinkedHashSet<IArtifactReference>();
    protected List<IArtifactReference> tempRefStorePostDeserialization = null;
    private volatile transient int hashCode = 0;

    protected AbstractArtifact(ResourceLocation location) {
        this.location = location;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.location;
    }

    private void checkAndRestoreReferences() {
        if (this.tempRefStorePostDeserialization != null) {
            if (!this.tempRefStorePostDeserialization.isEmpty()) {
                this.references.addAll(this.tempRefStorePostDeserialization);
            }
            this.tempRefStorePostDeserialization = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReference(IArtifactReference reference) {
        Set<IArtifactReference> set = this.references;
        synchronized (set) {
            this.checkAndRestoreReferences();
            boolean merged = false;
            for (IArtifactReference existingReference : this.references) {
                if (!existingReference.canMerge(reference)) continue;
                merged = true;
                existingReference.merge(reference);
                break;
            }
            if (!merged) {
                this.references.add(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IArtifactReference> getReferences() {
        Set<IArtifactReference> set = this.references;
        synchronized (set) {
            this.checkAndRestoreReferences();
        }
        return Collections.unmodifiableSet(new LinkedHashSet<IArtifactReference>(this.references));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReferences(String collectorID, ITransactionContext txContext) {
        Set<IArtifactReference> set = this.references;
        synchronized (set) {
            this.checkAndRestoreReferences();
            Iterator<IArtifactReference> iter = this.references.iterator();
            while (iter.hasNext()) {
                IArtifactReference reference = iter.next();
                reference.removeLocations(collectorID);
                if (!reference.getLocations().isEmpty()) continue;
                iter.remove();
                reference.dispose(txContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReferences() {
        Set<IArtifactReference> set = this.references;
        synchronized (set) {
            this.references.clear();
            this.tempRefStorePostDeserialization = null;
        }
    }

    public String toString() {
        return new StringBuffer(this.getType()).append("[").append(this.getName()).append("] @ ").append(this.getLocation() == null ? "Unknown" : this.getLocation().toString()).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractArtifact) {
            AbstractArtifact other = (AbstractArtifact)obj;
            ResourceLocation location = this.getLocation();
            IProject project = this.getProject();
            return this.getName().equals(other.getName()) && this.getType().equals(other.getType()) && (location == null ? other.getLocation() == null : location.equals(other.getLocation())) && (project == null ? other.getProject() == null : project.equals((Object)other.getProject()));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(this.getName());
            hcu.hash(this.getType());
            hcu.hash(this.getLocation());
            hcu.hash(this.getProject());
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Set<IArtifactReference> set = this.references;
        synchronized (set) {
            this.checkAndRestoreReferences();
            out.writeObject(this.location);
            out.writeObject(new ArrayList<IArtifactReference>(this.references));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalFieldFromStream(this, "location", ResourceLocation.class);
        su.setFinalField(this, "references", Set.class, new LinkedHashSet());
        Object value = in.readObject();
        if (value != null && !(value instanceof List)) {
            throw new IllegalStateException("Current data in stream is not of correct type.");
        }
        this.tempRefStorePostDeserialization = (List)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTempReferences(Collection<IArtifactReference> references) {
        if (references == null) {
            return;
        }
        Collection<IArtifactReference> collection = references;
        synchronized (collection) {
            if (this.tempRefStorePostDeserialization == null) {
                this.tempRefStorePostDeserialization = new ArrayList<IArtifactReference>();
            }
            this.tempRefStorePostDeserialization.addAll(references);
        }
    }
}

