/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.confvalidation;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.confvalidation.ConfValidationUtil;
import oracle.eclipse.tools.common.services.util.AbstractFacetResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.framework.Version;

public class ValidationContext {
    private final IResource _res;
    private final AbstractFacetResolver _facetResolver;

    public ValidationContext(IResource res) {
        this(res, new AbstractFacetResolver.DefaultFacetResolver());
    }

    public ValidationContext(IResource res, AbstractFacetResolver facetResolver) {
        this._res = res;
        this._facetResolver = facetResolver;
    }

    public IResource getResource() {
        return this._res;
    }

    public Set<IProjectFacetVersion> getInstalledFacets() {
        IProject project = this.getResource().getProject();
        try {
            return this._facetResolver.getInstalledFacets(project);
        }
        catch (CoreException e) {
            Activator.log("Getting installed facets", e);
            return Collections.emptySet();
        }
    }

    public boolean areFacetsInstalled(Set<IProjectFacetVersion> expectedFacets) {
        Set<IProjectFacetVersion> installedFacets = this.getInstalledFacets();
        if (installedFacets.isEmpty()) {
            return false;
        }
        for (IProjectFacetVersion expected : expectedFacets) {
            IProjectFacet expectedProjFacet = expected.getProjectFacet();
            boolean wasFound = false;
            for (IProjectFacetVersion installedFacet : installedFacets) {
                if (!installedFacet.getProjectFacet().getId().equals(expectedProjFacet.getId()) || this.compareTo(expected.getVersionString(), installedFacet) != 0) continue;
                wasFound = true;
                break;
            }
            if (wasFound) continue;
            return false;
        }
        return true;
    }

    public boolean isMinimumFacetInstalled(String id, String minVersion) {
        for (IProjectFacetVersion version : this.getInstalledFacets()) {
            if (!id.equals(version.getProjectFacet().getId()) || this.compareTo(minVersion, version) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean isMinimumTechExtensionVersion(String id, String minVersionStr) {
        IProject project = this._res.getProject();
        return ConfValidationUtil.checkProjectMeetsMinimumTechnology(id, minVersionStr, project);
    }

    private int compareTo(String minVersion, IProjectFacetVersion thisVersion) {
        String versionString = thisVersion.getVersionString();
        Version parseVersion = Version.parseVersion((String)versionString);
        Version minVer = Version.parseVersion((String)minVersion);
        return minVer.compareTo(parseVersion);
    }
}

