/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.confvalidation;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.catalogue.message.CataloguedMessage;
import oracle.eclipse.tools.common.services.confvalidation.AbstractConfigValidationDelegate;
import oracle.eclipse.tools.common.services.confvalidation.ProblemCatalogueInstance;
import oracle.eclipse.tools.common.services.confvalidation.ValidationContext;
import oracle.eclipse.tools.common.services.confvalidation.ValidationDelegateExtensionRegistry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ConfigurationValidator
extends AbstractValidator
implements IValidator {
    private final List<? extends AbstractConfigValidationDelegate> _delegates;

    public ConfigurationValidator() {
        this._delegates = ValidationDelegateExtensionRegistry.INSTANCE.getExtensions();
        for (AbstractConfigValidationDelegate abstractConfigValidationDelegate : this._delegates) {
            abstractConfigValidationDelegate.setCatalogue(ProblemCatalogueInstance.getInstance());
        }
    }

    public ConfigurationValidator(List<? extends AbstractConfigValidationDelegate> delegates) {
        this._delegates = delegates;
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult vr = new ValidationResult();
        if (resource == null || !(resource instanceof IFile)) {
            return vr;
        }
        IReporter reporter = vr.getReporter(monitor);
        try {
            this.validateFile((IFile)resource, reporter);
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
        return vr;
    }

    private void validateFile(final IFile resource, IReporter reporter) throws ValidationException {
        final ArrayList messages = new ArrayList();
        for (final AbstractConfigValidationDelegate abstractConfigValidationDelegate : this._delegates) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ValidationContext context = new ValidationContext((IResource)resource);
                    if (abstractConfigValidationDelegate.isEnabled(context)) {
                        messages.addAll(abstractConfigValidationDelegate.validate(context));
                    }
                }

                public void handleException(Throwable exception) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "oracle.eclipse.tools.common.services", "Validator failed", exception));
                }
            });
        }
        for (CataloguedMessage cataloguedMessage : messages) {
            reporter.addMessage((IValidator)this, (IMessage)cataloguedMessage);
        }
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris = helper.getURIs();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            IFile currentFile = null;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                if (currentFile != null && currentFile.exists()) {
                    this.validateFile(currentFile, reporter);
                }
                ++i;
            }
        }
    }
}

