/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.concurrency.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.eclipse.tools.common.services.concurrency.PreLockCommand;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ConcurrencyCommandBuilder {
    private String commandClassName = null;
    private String commandFactoryClassName = null;
    private Expression expression = null;
    private final String pluginID;

    public ConcurrencyCommandBuilder(String pluginID) {
        this.pluginID = pluginID;
    }

    public PreLockCommand build() {
        if (this.commandClassName == null && this.commandFactoryClassName == null) {
            throw new IllegalStateException("Exactly one of command-class or command-factory is allowed");
        }
        PreLockCommand lc = null;
        if (this.commandClassName != null) {
            lc = (PreLockCommand)PluginUtil.instantiate((String)this.pluginID, (String)this.commandClassName, PreLockCommand.class);
            if (lc == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Unable to instantiate " + this.commandClassName + " for plugin " + this.pluginID));
            }
        } else {
            Class commandFactoryClass = PluginUtil.loadClass((String)this.pluginID, (String)this.commandFactoryClassName);
            if (commandFactoryClass != null) {
                try {
                    Method getCommandMethod = commandFactoryClass.getMethod("getCommand", null);
                    Object command = getCommandMethod.invoke(null, null);
                    if (command instanceof PreLockCommand) {
                        lc = (PreLockCommand)command;
                    } else {
                        LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)(String.valueOf(this.commandFactoryClassName) + "#getCommand() did not return an instance of PreLockCommand"));
                    }
                }
                catch (NoSuchMethodException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
            }
        }
        return lc;
    }

    public ConcurrencyCommandBuilder setCommandClass(String commandClassName) {
        if (this.commandFactoryClassName != null) {
            throw new IllegalStateException("Exactly one of command-class or command-factory is allowed");
        }
        this.commandClassName = commandClassName;
        return this;
    }

    public ConcurrencyCommandBuilder setCommandFactoryClass(String commandFactoryClassName) {
        if (this.commandClassName != null) {
            throw new IllegalStateException("Exactly one of comamnd-class or command-factory is allowed");
        }
        this.commandFactoryClassName = commandFactoryClassName;
        return this;
    }

    public ConcurrencyCommandBuilder setEnablementExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public boolean isEnabledFor(IProject project) throws CoreException {
        if (this.expression != null) {
            EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
            evalContext.setAllowPluginActivation(true);
            return EvaluationResult.TRUE == this.expression.evaluate((IEvaluationContext)evalContext);
        }
        return true;
    }
}

