/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.concurrency;

import java.util.Set;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.concurrency.PreLockCommand;
import oracle.eclipse.tools.common.services.concurrency.internal.ConcurrencyCommandExtensionReader;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractJob
extends Job {
    private final Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
    private ISchedulingRule delayedRule = null;
    private final IProject project;

    public AbstractJob(String name, IProject project) {
        super(name);
        this.project = project;
    }

    /*
     * Loose catch block
     */
    public final IStatus run(IProgressMonitor monitor) {
        if (this.getRule() != null) {
            throw new IllegalStateException("Use setDelayedRule() instead of setRule()");
        }
        try {
            IStatus iStatus;
            block20: {
                ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)100);
                Job.getJobManager().beginRule(this.delayedRule, monitor);
                Job.getJobManager().endRule(this.delayedRule);
                int depth = -1;
                try {
                    long startTime = 0L;
                    if (TraceOptions.APPXRAY_PERF) {
                        startTime = System.currentTimeMillis();
                        TraceOptions.log(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " begin runPreLockCommands() for " + this.project.getName());
                    }
                    this.runPreLockCommands();
                    if (TraceOptions.APPXRAY_PERF) {
                        long totalTime = System.currentTimeMillis() - startTime;
                        TraceOptions.log(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " end runPreLockCommands() for " + this.project.getName() + " with time, " + totalTime);
                    }
                }
                catch (InterruptedException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                try {
                    Job.getJobManager().beginRule(this.delayedRule, monitor);
                    this.workspace.prepareOperation(null, monitor);
                    this.workspace.beginOperation(true);
                    depth = this.workspace.getWorkManager().beginUnprotected();
                    long startTime = 0L;
                    if (TraceOptions.APPXRAY_PERF) {
                        startTime = System.currentTimeMillis();
                        TraceOptions.log(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " begin runAfterCommands() for " + this.project.getName());
                    }
                    IStatus status = this.runAfterCommands(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)99));
                    if (TraceOptions.APPXRAY_PERF) {
                        long totalTime = System.currentTimeMillis() - startTime;
                        TraceOptions.log(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " end runAfterCommands() for " + this.project.getName() + " with time, " + totalTime);
                    }
                    iStatus = status;
                    if (depth < 0) break block20;
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus2;
                    block21: {
                        this.workspace.getWorkManager().operationCanceled();
                        iStatus2 = Status.CANCEL_STATUS;
                        if (depth < 0) break block21;
                        this.workspace.getWorkManager().endUnprotected(depth);
                    }
                    this.workspace.endOperation(null, false, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                    Job.getJobManager().endRule(this.delayedRule);
                    ProgressMonitorUtil.done((IProgressMonitor)monitor);
                    return iStatus2;
                    {
                        catch (Throwable throwable) {
                            try {
                                if (depth >= 0) {
                                    this.workspace.getWorkManager().endUnprotected(depth);
                                }
                                this.workspace.endOperation(null, false, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                                Job.getJobManager().endRule(this.delayedRule);
                                throw throwable;
                            }
                            catch (CoreException e) {
                                IStatus iStatus3 = e.getStatus();
                                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                                return iStatus3;
                            }
                        }
                    }
                }
                this.workspace.getWorkManager().endUnprotected(depth);
            }
            this.workspace.endOperation(null, false, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
            Job.getJobManager().endRule(this.delayedRule);
            return iStatus;
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    protected abstract IStatus runAfterCommands(IProgressMonitor var1) throws CoreException;

    public void setDelayedRule(ISchedulingRule rule) {
        this.delayedRule = rule;
    }

    private final void runPreLockCommands() throws InterruptedException {
        Set<PreLockCommand> commands = ConcurrencyCommandExtensionReader.getCommands(this.project);
        for (PreLockCommand command : commands) {
            command.execute(this.delayedRule, this.isIncrementalJob());
        }
    }

    protected boolean isIncrementalJob() {
        return false;
    }
}

