/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.classpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.classpath.AbstractOepeClasspathContainerFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class OepeClasspathContainerFactoryRegistry {
    public static final OepeClasspathContainerFactoryRegistry INSTANCE = new OepeClasspathContainerFactoryRegistry();
    private Map<String, ClasspathContainerFactoryExtension> factories;

    public AbstractOepeClasspathContainerFactory getFactory(String id) {
        this.ensureInitialized();
        ClasspathContainerFactoryExtension factoryExtension = this.factories.get(id);
        if (factoryExtension != null) {
            return factoryExtension.getFactory();
        }
        return null;
    }

    public List<String> getFactories() {
        this.ensureInitialized();
        ArrayList<String> ids = new ArrayList<String>(this.factories.size());
        for (String id : this.factories.keySet()) {
            ids.add(id);
        }
        return ids;
    }

    public String getDescription(String forId) {
        this.ensureInitialized();
        ClasspathContainerFactoryExtension extension = this.factories.get(forId);
        if (extension == null) {
            throw new IllegalArgumentException();
        }
        return extension.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        OepeClasspathContainerFactoryRegistry oepeClasspathContainerFactoryRegistry = this;
        synchronized (oepeClasspathContainerFactoryRegistry) {
            if (this.factories == null) {
                this.factories = new HashMap<String, ClasspathContainerFactoryExtension>();
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint point = registry.getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName(), "oepeClasspathContainer");
                if (point != null) {
                    IConfigurationElement[] configurationElements;
                    IConfigurationElement[] iConfigurationElementArray = configurationElements = point.getConfigurationElements();
                    int n = configurationElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        String id = element.getAttribute("id");
                        String description = element.getAttribute("description");
                        try {
                            Object factory = element.createExecutableExtension("class");
                            if (factory instanceof AbstractOepeClasspathContainerFactory) {
                                this.factories.put(id, new ClasspathContainerFactoryExtension(id, description, (AbstractOepeClasspathContainerFactory)factory));
                            }
                        }
                        catch (CoreException e) {
                            Activator.log((Exception)((Object)e));
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    private static class ClasspathContainerFactoryExtension {
        private final String id;
        private final String description;
        private final AbstractOepeClasspathContainerFactory factory;

        public ClasspathContainerFactoryExtension(String id, String description, AbstractOepeClasspathContainerFactory factory) {
            this.id = id;
            this.description = description;
            this.factory = factory;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public AbstractOepeClasspathContainerFactory getFactory() {
            return this.factory;
        }
    }
}

