/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.catalogue.message;

import java.util.Locale;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogueIndex;
import org.eclipse.wst.validation.internal.core.Message;

public class CataloguedMessage
extends Message {
    public static final String KEY_CATALOGUED_INDEX = "oracle.eclipse.tools.KEY_CATALOGUED_INDEX";
    private Integer _actualSeverity;
    private String _text;

    public CataloguedMessage(String aBundleName, String anId, Object aTargetObject, ProblemCatalogueIndex index) {
        super(aBundleName, index.getDefaultSeverity(), index.getId(), new String[0], aTargetObject);
        this.setAttribute(KEY_CATALOGUED_INDEX, index.getKey());
        this.setSeverity(this.convert(index.getDefaultSeverity()));
        this._text = index.getMessage();
    }

    public String getText(Locale locale, ClassLoader classLoader) {
        return this._text;
    }

    private ProblemCatalogueIndex getIndex() {
        return (ProblemCatalogueIndex)this.getAttributes().get(KEY_CATALOGUED_INDEX);
    }

    public int getSeverity() {
        if (this._actualSeverity == null) {
            return this.convert(this.getIndex().getDefaultSeverity());
        }
        return this._actualSeverity;
    }

    private int convert(int statusSeverity) {
        switch (statusSeverity) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid status severity: " + statusSeverity);
    }

    public void setSeverity(int newSeverity) {
        this._actualSeverity = newSeverity;
    }

    public String toString() {
        return this.getText();
    }
}

