/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.catalogue;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.catalogue.CatalogueIndex;

public class Catalogue {
    private Map<String, Map<String, CatalogueIndex>> _indices;
    private Set<Policy> _policies;

    public Catalogue() {
        this(Collections.singleton(Policy.NO_DUPLICATE_ADDS));
    }

    public Catalogue(Set<Policy> policies) {
        this._policies = policies;
        this._indices = new HashMap<String, Map<String, CatalogueIndex>>();
    }

    public void addIndex(CatalogueIndex index) {
        String srcId = index.getSrcId();
        Map<String, CatalogueIndex> indices = this._indices.get(srcId);
        if (indices == null) {
            indices = new HashMap<String, CatalogueIndex>();
            this._indices.put(srcId, indices);
        }
        if (this._policies.contains((Object)Policy.NO_DUPLICATE_ADDS) && this.getIndex(index.getSrcId(), index.getId()) != null) {
            throw new IllegalArgumentException("Policy is no duplicate adds, attempted to add duplicate");
        }
        indices.put(index.getId(), index);
    }

    public CatalogueIndex getIndex(String srcId, String id) {
        Map<String, CatalogueIndex> indices = this._indices.get(srcId);
        if (indices == null) {
            return null;
        }
        for (Map.Entry<String, CatalogueIndex> indexMapEntry : indices.entrySet()) {
            if (!indexMapEntry.getKey().equals(id)) continue;
            return indexMapEntry.getValue();
        }
        return null;
    }

    public Map<String, ? extends CatalogueIndex> getIndices(String srcId) {
        return Collections.unmodifiableMap(this._indices.get(srcId));
    }

    public CatalogueIndex findByKey(String key) {
        for (Map.Entry<String, Map<String, CatalogueIndex>> entrySet : this._indices.entrySet()) {
            for (Map.Entry<String, CatalogueIndex> innerEntrySet : entrySet.getValue().entrySet()) {
                if (!innerEntrySet.getValue().getKey().equals(key)) continue;
                return innerEntrySet.getValue();
            }
        }
        return null;
    }

    public int size() {
        int size = 0;
        for (Map.Entry<String, Map<String, CatalogueIndex>> entries : this._indices.entrySet()) {
            size += entries.getValue().size();
        }
        return size;
    }

    public static enum Policy {
        NO_DUPLICATE_ADDS;

    }
}

