/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.utils;

import oracle.eclipse.tools.common.services.appgen.utils.IJavaProjectFileProvider;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

public class DefaultJavaProjectFileProvider
implements IJavaProjectFileProvider {
    private final IProject _project;
    private final String _srcFolderName;

    public DefaultJavaProjectFileProvider(IProject project, String srcFolderName) {
        if (project == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Project is null");
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)iae);
            throw iae;
        }
        IJavaProject javaProject = JavaUtil.getJavaProject((IProject)project);
        if (javaProject == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Java project required");
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)iae);
            throw iae;
        }
        this._project = project;
        this._srcFolderName = srcFolderName;
    }

    @Override
    public IProject getProject() {
        return this._project;
    }

    @Override
    public IFile getSourceFolderFile(String pkg, String name) {
        return this.getSrcFolderFile(this._srcFolderName, pkg, name);
    }

    @Override
    public IFile getJavaFile(String className) {
        if (className != null) {
            String pkg = null;
            String simpleName = className;
            int index = className.lastIndexOf(".");
            if (index > 0) {
                pkg = className.substring(0, index);
                simpleName = className.substring(index + 1);
            }
            return this.getSourceFolderFile(pkg, String.valueOf(simpleName) + ".java");
        }
        return null;
    }

    private IFile getSrcFolderFile(String possibleMatch, String pkg, String name) {
        IPath path = this.getSrcFolderPath(possibleMatch);
        if (pkg != null && !pkg.isEmpty()) {
            path = path.append(pkg.replace('.', '/'));
        }
        path = path.append(name);
        return this.getProject().getFile(path);
    }

    private IPath getSrcFolderPath(String possibleMatch) {
        IPath firstSrcFolderPath = null;
        IJavaProject javaProject = JavaUtil.getJavaProject((IProject)this.getProject());
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1) {
                    if (firstSrcFolderPath == null) {
                        firstSrcFolderPath = root.getResource().getProjectRelativePath();
                    }
                    if (possibleMatch == null) {
                        return firstSrcFolderPath;
                    }
                    IPath srcFolderPath = root.getResource().getProjectRelativePath();
                    if (possibleMatch.equals(srcFolderPath.toString())) {
                        return srcFolderPath;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)((Object)jme));
        }
        return firstSrcFolderPath;
    }
}

