/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.templating;

import com.bea.wlw.template.exceptions.GenerationFailedException;
import java.io.StringWriter;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.appgen.Messages;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.templating.ITemplateContext;
import oracle.eclipse.tools.common.templating.template.core.TemplateService;

public class TemplateProcessor {
    public static String process(String name, ITemplateContext templateContext) throws GenerationException {
        String output = null;
        if (TraceOptions.TEMPLATE_PROCESSING) {
            TraceOptions.log("Template Processing BEGIN for " + name);
        }
        try {
            try {
                StringWriter outputWriter = new StringWriter();
                TemplateService.generate((String)templateContext.getTemplateId(), templateContext.getContextObjectCollection(), (StringWriter)outputWriter);
                output = outputWriter.toString();
            }
            catch (GenerationFailedException e) {
                String message = String.format(Messages.TemplateProcessor_process_failed, templateContext.getTemplateId());
                throw new GenerationException(message, e);
            }
        }
        catch (Throwable throwable) {
            if (TraceOptions.TEMPLATE_PROCESSING) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("Template Processing output is...\n");
                sb.append(output != null ? output : "NULL\n");
                sb.append("Template Processing END for ").append(name);
                TraceOptions.log(sb.toString());
            }
            throw throwable;
        }
        if (TraceOptions.TEMPLATE_PROCESSING) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("Template Processing output is...\n");
            sb.append(output != null ? output : "NULL\n");
            sb.append("Template Processing END for ").append(name);
            TraceOptions.log(sb.toString());
        }
        return output;
    }
}

